// Comparator used to compare step expansion (current line of expansion) on instantiated steps.

package abl.runtime;

import java.util.Comparator;

class StepExpansionComparator implements Comparator {
    
    /* Compares two steps to see if they are on the current line of expansion.
       Returns value > 0 if o1.currentLineOfExpansion() && !o2.currentLineOfExpansion()
       Returns value = 0 if o1.currentLineOfExpansion() == o2.currentLineOfExpansion()
       Returns value < 0 if !o1.currentLineOfExpansion() && o2.currentLineOfExpansion()
       Note: this comparator imposes orderings that are inconsistent with equals() because 
       it inherits equals from Object which tests for *reference* equality. */
    public int compare(Object o1, Object o2) {
	boolean b1 = ((Step)o1).currentLineOfExpansion(null);
	boolean b2 = ((Step)o2).currentLineOfExpansion(null);
	int compareVal = 0; // Make the compiler happy by initializing variable. 

	if (b1 && !b2) compareVal = -1;
	else if (b1 == b2) compareVal = 0;
	else if (!b1 && b2) compareVal = 1;
	return compareVal;
    }
}
