// WME wrapper for sequential behaviors

package abl.runtime;
import java.beans.*;
// import debug.*;

public class SequentialBehaviorWME extends BehaviorWME
{
    protected StepWME child = null;

    private class SequentialBehaviorChildChangeListener implements PropertyChangeListener
    {
	SequentialBehaviorWME sequentialBehaviorWME;
	
	SequentialBehaviorChildChangeListener(SequentialBehaviorWME s) { sequentialBehaviorWME = s; }
	public void propertyChange(PropertyChangeEvent evt) {
	    assert ((evt.getOldValue() == null) || (evt.getNewValue() == null)) &&
		((evt.getOldValue() != null) || (evt.getNewValue() != null)):
		"Behavior " + behavior; // old value == null xor new value == null

	    if (evt.getOldValue() == null) {
		// adding a step child

		// fixme: remove
		// This is in here to debug the null pointer error that often shows up with DoDialog - want to see if a thread other than the decision
		// cycle is ever responsible for adding the step.
		if (BehavingEntity.getBehavingEntity().getBehavingEntityShortName().equals("Trip") &&
		    behavior.getSignature().equals("DoDialog(int, boolean, int, int, int, int, boolean)")) {
		    assert Thread.currentThread().getName().equals("DecisionCycleThread"): "Thread adding a step reflection wme = " + Thread.currentThread();
		}
	    
		// if we're adding a child, then there currently shouldn't be a child
		assert sequentialBehaviorWME.child == null: "Behavior " + behavior; 

		Step newStep = (Step)evt.getNewValue();
		switch (newStep.getStepType()) {
		case Step.GOAL:
		    sequentialBehaviorWME.setChild(new GoalStepWME((GoalStep)newStep, sequentialBehaviorWME));
		    break;
		case Step.PRIMITIVE:
		    sequentialBehaviorWME.setChild(new PrimitiveStepWME((PrimitiveStep)newStep, sequentialBehaviorWME));
		    break;
		case Step.WAIT:
		    sequentialBehaviorWME.setChild(new WaitStepWME((WaitStep)newStep, sequentialBehaviorWME));
		    break;
		case Step.MENTAL:
		    sequentialBehaviorWME.setChild(new MentalStepWME((MentalStep)newStep, sequentialBehaviorWME));
		    break;
		case Step.FAIL:
		    sequentialBehaviorWME.setChild(new FailStepWME((FailStep)newStep, sequentialBehaviorWME));
		    break;
		case Step.SUCCEED:
		    sequentialBehaviorWME.setChild(new SucceedStepWME((SucceedStep)newStep, sequentialBehaviorWME));
		    break;		    
		}
		BehavingEntity.getBehavingEntity().addWME(sequentialBehaviorWME.child);
	    }
	    else {
		// remove a step child

		// fixme: remove
		/* if (BehavingEntity.getBehavingEntity().getBehavingEntityShortName().equals("Trip") &&
		    behavior.getSignature().equals("DoDialog(int, boolean, int, int, int, int, boolean)"))
		    System.out.println("Thread deleting a step reflection wme = " + Thread.currentThread());
		*/

		// if we're removing a child, then there currently should be a child
		assert sequentialBehaviorWME.child != null: "Behavior " + behavior; 

		BehavingEntity.getBehavingEntity().deleteWME(sequentialBehaviorWME.child);
		sequentialBehaviorWME.getChild().delete(); // update child step state so that it no longer wraps a valid ABT node
		sequentialBehaviorWME.setChild(null);
	    }
	}
    }

    public SequentialBehaviorWME(SequentialBehavior sequentialBehavior, GoalStepWME parent) { 
	super(sequentialBehavior, parent); 
	sequentialBehavior.addChildChangeListener(new SequentialBehaviorChildChangeListener(this));
    }
	
    
    // ### Accessors ###
    
    public synchronized StepWME getChild() { return child; }
    public synchronized int getBehaviorType() { return behavior.getBehaviorType(); }
    private synchronized void setChild(StepWME stepWME) { child = stepWME; }
}
    
    
    
