// Sequential behaviors
package abl.runtime;

import java.util.*;
// import debug.*;
import java.lang.reflect.Method;

public class SequentialBehavior extends Behavior {

	// State used by getNextStep to figure out which step needs to be returned.
	private int stepCounter = 0;

	// Current child step for this sequential behavior.
	private Step child;

	// Initialize behaviorType as a static variable shared by all
	// SequentialBehaviors.
	protected static short behaviorType = Behavior.SEQUENTIAL;

	// fixme: currently passing null success condition to super constructor.
	// Eventually require success condition to be explicitly set when we thread
	// the success condition through the compiler.
	public SequentialBehavior(GoalStep arg_parent, Method arg_contextCondition,
			Method arg_contextConditionSensorFactory,
			Method arg_successCondition,
			Method arg_successConditionSensorFactory, boolean arg_isAtomic,
			String arg_signature, short arg_specificity, int arg_behaviorID,
			Object[] arg_behaviorVariableFrame, __StepDesc[] arg_stepDescs) {
		super(arg_parent, arg_contextCondition,
				arg_contextConditionSensorFactory, arg_successCondition,
				arg_successConditionSensorFactory, arg_isAtomic, arg_signature,
				arg_specificity, arg_behaviorID, arg_behaviorVariableFrame,
				arg_stepDescs);
	}

	// fixme: currently passing null success condition to super constructor.
	// Eventually require success condition to be explicitly set when we thread
	// the success condition through the compiler.
	public SequentialBehavior(GoalStep arg_parent, Method arg_contextCondition,
			Method arg_contextConditionSensorFactory,
			Method arg_successCondition,
			Method arg_successConditionSensorFactory, boolean arg_isAtomic,
			String arg_signature, short arg_specificity, int arg_behaviorID,
			Object[] arg_behaviorVariableFrame, __StepDesc[] arg_stepDescs,
			BehavingEntity[] arg_teamMembers) {
		super(arg_parent, arg_contextCondition,
				arg_contextConditionSensorFactory, arg_successCondition,
				arg_successConditionSensorFactory, arg_isAtomic, arg_signature,
				arg_specificity, arg_behaviorID, arg_behaviorVariableFrame,
				arg_stepDescs, arg_teamMembers);
	}

	// accessor for behaviorType.
	final short getBehaviorType() {
		return behaviorType;
	}

	// accessor for the child
	final Step getChild() {
		return child;
	}

	// Returns the next step.
	final Step getNextStep() {
		if (stepCounter == stepDescs.length)
			return null; // no more steps to return.

		try {
			final Object[] factoryArgs = {
					new Integer(stepDescs[stepCounter].stepID), this,
					getBehaviorVariableFrame() };
			return (Step) stepDescs[stepCounter++].factory.invoke(null,
					factoryArgs);
		} catch (Exception e) {
			throw new AblRuntimeError("Error invoking step factory", e);
		}
	}

	// Adds the first step as a child.
	void addChildren() {
		assert (stepCounter == 0);
		child = getNextStep();
		BehavingEntity.getBehavingEntity().addStep(child);
		changes.firePropertyChange("child", null, child); // Fire property
															// change for any
															// listeners
	}

	// Adds a child step to the sequential behavior.
	final void addChild(Step s) {
		assert (child == null);
		child = s;
		BehavingEntity.getBehavingEntity().addStep(s);
		changes.firePropertyChange("child", null, child); // Fire property
															// change for any
															// listeners
	}

	// Removes the current child.
	final protected void removeChildren() {
		if (child != null)
			// If there is a child to remove, remove it.
			removeChild(child, false);
	}

	/*
	 * Removes a child from a seqeuntial behavior. First calls
	 * super.removeChild() which takes care of appropriate bookeeping depending
	 * on the type of the child and performs bookeeping on BehavingEntity. Then
	 * this more concrete method clears child.
	 */
	final protected void removeChild(Step childToRemove, boolean isCallerChild) {
		// If the child to be removed is not the current child, throw an error
		assert childToRemove == child : "childToRemove == " + childToRemove
				+ ": current child == " + child + " behavior: "
				+ getSignature();

		// Asked to remove a null child; throw an error.
		assert childToRemove != null : "Attempt to remove a null child from a sequential behavior.";

		super.removeChild(childToRemove, isCallerChild);
		child = null;
	}

	/*
	 * Returns true if the current goal is in the current line of expansion,
	 * false otherwise.
	 */
	final boolean currentLineOfExpansion(GoalStep currentGoal) {
		return parent.currentLineOfExpansion(currentGoal);
	}

	// Suspends the current active step of the SequentialBehavior
	final void suspend(ExecutableStep step) {
		child.suspend(step);
	}

	final void jointUnsuspend() {
		child.jointUnsuspend();
	}

	// Meta control for suspending the current active step of the
	// SequentialBehavior
	final void metaSuspend() {
		child.metaSuspend();
	}

	// Unsuspends the current active step of the SequentialBehavior
	final void unsuspend(ExecutableStep step) {
		child.unsuspend(step);
	}

	// Meta control for unsuspending the current active step of the
	// SequentialBehavior
	final void metaUnsuspend() {
		child.metaUnsuspend();
	}

	final void suspendSkipJointGoals(ExecutableStep step) {
		if (child != null
				&& !((child.getStepType() == Step.GOAL) && ((GoalStep) child)
						.isJointGoal())) {

			if (child.getStepType() == Step.GOAL)
				((GoalStep) child).suspendSkipJointGoals(step);
			else
				child.suspend(step);
		}
	}

	final void metaSuspendSkipJointGoals() {
		if (child != null
				&& !((child.getStepType() == Step.GOAL) && ((GoalStep) child)
						.isJointGoal())) {

			if (child.getStepType() == Step.GOAL)
				((GoalStep) child).metaSuspendSkipJointGoals();
			else
				child.metaSuspend();
		}
	}

	final List<Step> freezeSubtreeAndNegotiateRemoval() {
		if (hasTeamEffectOnlySteps())
			return freezeNonTeamEffectOnlySubtreeAndNegotiateRemoval();
		else {
			BehavingEntity.getBehavingEntity().removeBehavior(this); // remove
																		// the
																		// context
																		// condition
			if (child != null)
				return freezeChild(child);
			else
				return new Vector(0);
		}
	}

	final protected List<Step> freezeNonTeamEffectOnlySubtreeAndNegotiateRemoval() {
		BehavingEntity.getBehavingEntity().removeBehavior(this); // remove
																	// the
																	// context
																	// condition
		if (child != null && !child.getTeamEffectOnly())
			return freezeChild(child);
		else
			return new Vector<Step>(0);
	}

	final protected boolean hasTeamEffectOnlySteps() {
		if (child != null)
			return child.getTeamEffectOnly();
		else
			return false;
	}

	final List negotiateSuspensionOfSubtree(ExecutableStep s) {
		if (child != null)
			return negotiateSuspensionOfChild(child, s);
		else
			return new Vector(0);
	}

	final List negotiateSuspensionOfSubtree() {
		if (child != null)
			return negotiateSuspensionOfChild(child);
		else
			return new Vector(0);
	}

	final void insertStep(__StepDesc step, int index) {
		// the index used will displace the item already there by shifting it up
		// one index value
		if (0 > index || index > stepDescs.length)
			throw new RuntimeError("Invalid insertStep index (" + index + ")");
		__StepDesc[] newStepDescs = new __StepDesc[stepDescs.length + 1];
		for (int i = 0; i < stepDescs.length; ++i) {
			if (i < index)
				newStepDescs[i] = stepDescs[i];
			else if (i == index)
				newStepDescs[i] = step;
			else
				newStepDescs[i] = stepDescs[i + 1];
		}
		stepDescs = newStepDescs;
	}

	final void moveStep(int fromIndex, int toIndex) {
		// if toIndex is in the valid range, it will move
		// if toIndex is negative, it will delete
		if (0 > fromIndex || fromIndex >= stepDescs.length)
			throw new RuntimeError("Invalid moveStep fromIndex (" + fromIndex
					+ ")");
		if (toIndex > stepDescs.length)
			throw new RuntimeError("Invalid moveStep toIndex (" + toIndex + ")");
		// possible no-op
		if (fromIndex == toIndex)
			return;
		// size will normally be unchanged, but a deletion will lower it
		int newSize = stepDescs.length;
		if (toIndex < 0)
			newSize -= 1;
		// create a new array to modify
		__StepDesc[] newStepDescs = new __StepDesc[newSize];
		// remove the from-step
		for (int i = 0; i < stepDescs.length; ++i) {
			if (i < fromIndex)
				newStepDescs[i] = stepDescs[i];
			else
				newStepDescs[i] = stepDescs[i + 1];
		}
		// add the to-step
		if (toIndex >= 0) {
			for (int i = newStepDescs.length - 1; i > toIndex; --i) {
				newStepDescs[i] = newStepDescs[i - 1];
			}
			newStepDescs[toIndex] = stepDescs[fromIndex];
		}
		// note: the above could probably be consolidated into a single loop,
		// but i don't feel like introducing potential bugs right now.
		stepDescs = newStepDescs;
	}
}
