package abl.runtime;

import java.util.Arrays;

public class SensorActivation {
    public Sensor activeSensor;
    public Object[] arguments;
    public int referenceCount;

    public SensorActivation(Sensor sensorToSet, Object[] argsToSet) {
	activeSensor = sensorToSet;
	arguments = argsToSet;
	referenceCount = 1; // Initialize the reference count to 1 for new SensorActivations. 
    }

    /* Overrides Object.equals(). In order for two SensorActivations to
       be equal, the class of the active sensors must be the same (reference
       equality) and the arguments must be equal. Purposely *does not*
       include the reference count in the equality test. */
    public boolean equals(Object obj) {
	SensorActivation activationToCompare = (SensorActivation)obj;
	if ((activationToCompare.activeSensor.getClass() == activeSensor.getClass()) &&
	    Arrays.equals(activationToCompare.arguments, arguments))
	    return true;
	else
	    return false;
    }
}
