package abl.runtime;

/** All sensors must implement the interface Sensor. A concrete sensor
   class is responsible for detecting state changes in the world (most
   likely calling appropriate routines on the world interface) and
   appropriately updating WME state.  */
public abstract class Sensor {

    /** True if the sensor can be run in parallel with other
     sensors. Defaults to false. Should be set to the appropriate
     value in the constructors of concrete sensor subclasses. */
    protected boolean bCanBeParallel = false;

    /** One shot sensing occurs in preconditions. senseOneShot()
       performs appropriate one shot sensing, updates the WME's, and
       returns. */
    public abstract void senseOneShot(Object[] args);

    /** Performs any necessary state initialization prior to continuous
       sensing. */
    public abstract void initializeContinuous(Object[] args);

    /** Continuous sensing occurs in success tests and context
       conditions. As long as the condition containing the WME
       registered with the sensor is active, senseContinuous() will be
       called repeatedly the top level behave() loop. Implementations
       of sensor are responsible for updating WME's in an efficient
       manner, that is, only updating an associated sense WME if it has
       changed by more than some threshhold. */
    public abstract void senseContinuous(Object[] args);

    /** public accessor for bCanBeParallel */
    public boolean canBeParallel() {
	return bCanBeParallel;
    }
}


