/* Class for runtime errors generated during the run of a ABL program */

package abl.runtime;

import java.io.*;

public class RuntimeError extends Error {
    
    public RuntimeError(String s) {
	super(s);
    }

    public RuntimeError(String s, Throwable t) {
	super(fullErrorString(s, t));

    }

    protected static String fullErrorString(String s, Throwable t) {
	StringWriter tempWriter = new StringWriter();
	PrintWriter stackTrace = new PrintWriter(tempWriter);
	t.printStackTrace(stackTrace);
	return s + t.getMessage() + tempWriter;
    }	
}
