// Class for primitive steps (steps consisting of a primitive act). 

package abl.runtime;

import java.lang.reflect.Method;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.DefaultMutableTreeNode;

public class PrimitiveStepDebug extends PrimitiveStep implements DebuggableStep {
	/*
	 * When a PrimitiveStep is constructed, needs to be passed an instantiated
	 * PrimitiveAction object to associate with the PrimitiveStep.
	 */
	public PrimitiveStepDebug(int stepID, Behavior arg_parent,
			boolean arg_persistent, boolean arg_persistentWhenSucceeds,
			boolean arg_persistentWhenFails, boolean arg_ignoreFailure,
			boolean arg_effectOnly, boolean arg_teamEffectOnly,
			short arg_priority, short arg_priorityModifier, boolean arg_post,
			String arg_postMemory, Method arg_execute, Method arg_successTest,
			Method arg_successTestSensorFactory,
			AblNamedPropertySupport arg_propertyTable, PrimitiveAction arg_act,
			String[] arg_stepsIConflictWith, String arg_actName) {
		super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds,
				arg_persistentWhenFails, arg_ignoreFailure, arg_effectOnly,
				arg_teamEffectOnly, arg_priority, arg_priorityModifier,
				arg_post, arg_postMemory, arg_execute, arg_successTest,
				arg_successTestSensorFactory, arg_propertyTable, arg_act,
				arg_stepsIConflictWith, arg_actName);
	}

	// fixme: add trace support for suspend.

	final void execute() {
		((DebuggableBehavior) parent).traceAblExecutionEvent(
				AblEvent.ACT_EXECUTION, this, null, getNestLevel());
		super.execute();
	}

	final void succeedStep() {
		try {
			((DebuggableBehavior) parent).traceAblExecutionEvent(
					AblEvent.ACT_COMPLETION, this, new Boolean(true),
					getNestLevel());
		} catch (ClassCastException e) {
			final String eMessage = "ClassCastException while succeeding "
					+ this.getName() + " in Parent behavior sig = "
					+ parent.getSignature();
			throw new ClassCastException(eMessage);
		}
		super.succeedStep();
	}

	final void failStep() {
		try {
			((DebuggableBehavior) parent).traceAblExecutionEvent(
					AblEvent.ACT_COMPLETION, this, new Boolean(false),
					getNestLevel());
		} catch (ClassCastException e) {
			final String eMessage = "ClassCastException while failing "
					+ this.getName() + " in Parent behavior sig = "
					+ parent.getSignature();
			throw new ClassCastException(eMessage);
		}
		super.failStep();
	}

	final boolean successTest() {
		final boolean ret = super.successTest();
		if (ret == true)
			((DebuggableBehavior) parent).traceAblExecutionEvent(
					AblEvent.SUCCESS_TEST_SUCCESS, this, null, getNestLevel());

		return ret;
	}

	// Returns a tree node which wraps the subtree rooted at this node in the
	// ABT.
	public final MutableTreeNode getTree() {
		return new DefaultMutableTreeNode(this);
	}

	// fixme: change this from a recursive call to an accessor for the nest
	// level (see Behavior).
	// to do this, will need to reset the nest level when a goal spawns.
	public final int getNestLevel() {
		return ((DebuggableBehavior) parent).getNestLevel() + 1;
	}

}
