// WME wrapper for MultiStepBehaviors

package abl.runtime;

import java.util.*;
import java.beans.*;

public class MultiStepBehaviorWME extends BehaviorWME
{
    private final HashSet children = new HashSet(); // set of children StepWMEs
    private final Hashtable stepToWMETable = new Hashtable(); // table mapping Steps to StepWMEs

    private class MultiStepBehaviorChildChangeListener implements PropertyChangeListener
    {
	MultiStepBehaviorWME multiStepBehaviorWME;

	MultiStepBehaviorChildChangeListener(MultiStepBehaviorWME b) { multiStepBehaviorWME = b; }
	public void propertyChange(PropertyChangeEvent evt) {
	    assert (((evt.getOldValue() == null) || (evt.getNewValue() == null)) &&
		    ((evt.getOldValue() != null) || (evt.getNewValue() != null))); // old value == null xor new value == null
	    if (evt.getOldValue() == null) {
		// adding a step child
		Step newStep = (Step)evt.getNewValue();
		StepWME newStepWME = null;
		switch (newStep.getStepType()) {
		case Step.GOAL:
		    newStepWME = new GoalStepWME((GoalStep)newStep, multiStepBehaviorWME);
		    break;
		case Step.PRIMITIVE:
		    newStepWME = new PrimitiveStepWME((PrimitiveStep)newStep, multiStepBehaviorWME);
		    break;
		case Step.WAIT:
		    newStepWME = new WaitStepWME((WaitStep)newStep, multiStepBehaviorWME);
		    break;
		case Step.MENTAL:
		    newStepWME = new MentalStepWME((MentalStep)newStep, multiStepBehaviorWME);
		    break;
		case Step.FAIL:
		    newStepWME = new FailStepWME((FailStep)newStep, multiStepBehaviorWME);
		    break;
		case Step.SUCCEED:
		    newStepWME = new SucceedStepWME((SucceedStep)newStep, multiStepBehaviorWME);
		    break;		    
		}
		multiStepBehaviorWME.addChild(newStepWME, newStep);
		BehavingEntity.getBehavingEntity().addWME(newStepWME);
	    }
	    else {
		// remove a step child
		Step childToRemove = (Step)evt.getOldValue();
		StepWME childToRemoveWME = (StepWME)stepToWMETable.get(childToRemove);
		assert (childToRemoveWME != null);
		multiStepBehaviorWME.removeChild(childToRemoveWME, childToRemove);
		BehavingEntity.getBehavingEntity().deleteWME(childToRemoveWME);
		childToRemoveWME.delete(); // update child step state so that it no longer wraps a valid ABT node
	    }
	}
    }

    public MultiStepBehaviorWME(MultiStepBehavior multiStepBehavior, GoalStepWME parent) { 
	super(multiStepBehavior, parent); 
	behavior.addChildChangeListener(new MultiStepBehaviorChildChangeListener(this));
    }

    // ### Get Accessors ###

    public synchronized int getNumberNeededForSuccess() { return ((MultiStepBehavior)behavior).getNumberNeededForSuccess(); }
    public synchronized int getNumberOfCompletedSteps() { return ((MultiStepBehavior)behavior).getNumberOfCompletedSteps(); }
    
    // fixme: need to wrap the lastPursuedGoal in a GoalStepWME, but it won't have a parent (or I need to figure out some way to find its parent)
    // I could register another listener on the MultiStepBehavior which makes a callback every time the last pursued goal changes.
    // public synchronized int getLastPursuedGoal() { return ((MultiStepBehavior)behavior).getLastPursuedGoal(); }

    public synchronized int getNumberOfSteps() { return ((MultiStepBehavior)behavior).getNumberOfSteps(); }
    public synchronized int getBehaviorType() { return behavior.getBehaviorType(); }
    public synchronized StepWME[] getChildren() { return (StepWME[])children.toArray(new StepWME[children.size()]); }

    // ### private set accessors ###
    private synchronized void addChild(StepWME stepWME, Step step) {
	children.add(stepWME);
	stepToWMETable.put(step, stepWME);
    };
    
    private synchronized void removeChild(StepWME stepWME, Step step) {
	children.remove(stepWME);
	stepToWMETable.remove(step);
    }
}
    
