// Class for wait steps. 
package abl.runtime;

import java.lang.reflect.Method;

public class ModifyStep extends Step {

    public static final short MOVESTEP = 0;
    public static final short DELETESTEP = 1;
    public static final short ADDSTEP = 2;

	private short mModifyType = -1;
	private int mTargetStepID = -4;
	private int mFromIndex = -1;
	private int mToIndex = -1;
	private Method mArgFactory = null;

    public ModifyStep(int stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, 
		    boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, 
		    boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, 
		    String arg_postMemory, Method arg_execute, Method arg_successTest, Method arg_successTestSensorFactory, 
		    AblNamedPropertySupport arg_propertyTable,
			short modifyType, int subStepID, int fromIndex, int toIndex, Method arg_factory)
    {
	super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, arg_ignoreFailure, 
	      arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, 
	      arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable, MODIFY);
	mModifyType = modifyType;
	mTargetStepID = subStepID;
	mFromIndex = fromIndex;
	mToIndex = toIndex;
	mArgFactory = arg_factory;
    }

    // Reseting a wait step does nothing. It should never be called. 
    void resetStep() {
	throw new RuntimeError("Attempt to reset a modify step.");
    }

    // reroots the goal at newParent
    private void modifyBehavior(SequentialBehaviorWME targetBehaviorWME) 
    {
		// success of the step will cause removal of the corresponding reflection WME
		succeedStep(); // Step succeeds immediately
		
		Behavior targetBehavior;
		// this change is transparent to the reflection WMEs
		if (targetBehaviorWME == null) 
			throw new RuntimeError("Attempt to modify a non-existent Sequential Behavior.");
		else 
			// spawning at parent
			targetBehavior = targetBehaviorWME.getBehavior();

		switch (mModifyType)
		{
		default:
			throw new RuntimeError("Invalid modifyType in ModifyStep");
		case MOVESTEP:
			((SequentialBehavior)targetBehavior).moveStep(mFromIndex, mToIndex);
			break;
		case DELETESTEP:
			((SequentialBehavior)targetBehavior).moveStep(mFromIndex, -1);
			break;
		case ADDSTEP:
			__StepDesc newStep = new __StepDesc(mTargetStepID, mArgFactory);
			((SequentialBehavior)targetBehavior).insertStep(newStep, mToIndex);
			break;
		}
    }
	
	private final SequentialBehaviorWME bindArgs() {
		SequentialBehaviorWME targetBehavior = null;
		if (execute != null) {
			// The goal step has args, so a bind args case has been defined in GoalStepExecute.
			final Object[] exeArgs = { new Integer(stepID), null, BehavingEntity.getBehavingEntity() };
			try { 
				final Object[] tempArgs = (Object[])execute.invoke(null, exeArgs);
				targetBehavior = (SequentialBehaviorWME)tempArgs[0];
			}
			catch (Exception e)
			{  throw new AblRuntimeError("Error invoking execute", e); }
		}
		return targetBehavior;
	}

    // Executing a wait step does nothing. It should never be called. 
    void execute() {
		SequentialBehaviorWME target = bindArgs();
		modifyBehavior(target);
    }

}




