// Received a message when a negotiator had already commited

package abl.runtime;

public class MessageReceivedAfterCommitError extends JointGoalNegotiationError {
    
    static protected String messageName(int message)
    {
	switch (message) {
	case JointGoalNegotiator.SUCCEED:
	    return "SUCCEED";
	case JointGoalNegotiator.FAIL:
	    return "FAIL";
	case JointGoalNegotiator.REMOVE:
	    return "REMOVE";
	case JointGoalNegotiator.SUSPEND:
	    return "SUSPEND";
	case JointGoalNegotiator.UNSUSPEND:
	    return "UNSUSPEND";
	default:
	    return "UNKNOWN MESSAGE";
	}
    }

    public MessageReceivedAfterCommitError(int message, int state) 
    { 
	super("Received message " + messageName(message) + " in commit state " + stateName(state));
    }

    public MessageReceivedAfterCommitError(int message, int state, JointGoalStep s)
    {
	super("Received message " + messageName(message) + " in commit state " + stateName(state) + " in goal " + s);
    }
}
