package abl.runtime;

import abl.compiler.AblDebuggerConstants;
import java.lang.reflect.Method;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.DefaultMutableTreeNode;

public class MentalStepDebug extends MentalStep implements DebuggableStep, AblDebuggerConstants {

    private final byte debugLevel; 

    private final String uniqueStepName;

    public MentalStepDebug(int arg_stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, 
		      boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, 
		      boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, 
		      String arg_postMemory, Method arg_execute, Method arg_successTest, 
		      Method arg_successTestSensorFactory, AblNamedPropertySupport arg_propertyTable, byte arg_debugLevel,
		      String arg_uniqueStepName)
    {
	super(arg_stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, 
	      arg_ignoreFailure, arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, 
	      arg_postMemory, arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable);
	debugLevel = arg_debugLevel;
	uniqueStepName = arg_uniqueStepName;
    }

    // fixme: add trace support for suspend.

    final void execute() 
    {
	if (debugLevel == GUI_DEBUGGER)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.MENTAL_STEP_EXECUTION, this, null, getNestLevel());

	final Thread timeCheck = new Thread() { 
		public void run() { 
		    try {
			sleep(1000); 
			System.err.println("WARNING: a mental act in behavior " + parent + " took longer than a second to complete. Mental acts that take a long time to execute block the decision cycle."); 
		    } catch (InterruptedException e) { } // Do nothing - this thread will be interrupted after execution finishes
		} };
	    
	timeCheck.start();
	super.execute();
	timeCheck.interrupt();
    }

    final void succeedStep() 
    {
	if (debugLevel == GUI_DEBUGGER)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.MENTAL_STEP_COMPLETION, this, new Boolean(true), getNestLevel());
	super.succeedStep();
    }

    final void failStep() 
    {
	if (debugLevel == GUI_DEBUGGER)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.MENTAL_STEP_COMPLETION, this, new Boolean(false), getNestLevel());
	super.failStep();
    }

    final boolean successTest()
    {
	final boolean ret = super.successTest();
	if (ret == true && debugLevel == GUI_DEBUGGER)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUCCESS_TEST_SUCCESS, this, null, getNestLevel());
	
	return ret;
    }

    // Returns a tree node which wraps the subtree rooted at this node in the ABT. 
    public final MutableTreeNode getTree() {
	return new DefaultMutableTreeNode(this);
    }

    // fixme: change this from a recursive call to an accessor for the nest level (see Behavior).
    // to do this, will need to reset the nest level when a goal spawns.
    public final int getNestLevel() {
	return ((DebuggableBehavior)parent).getNestLevel() + 1;
    }

    public final String toString() 
    {
	return "mental " + uniqueStepName;
    }
}



