package abl.runtime;

import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

public class MentalStep extends Step {

    // flag marking whether a mental step node is still valid.
    // flag set to false when this node is removed from the tree - used prevent problems with mental acts which end up removing themselves by reflection
    private boolean valid = true;

    // Constructor for GoalStep calls the super constructor. 
    public MentalStep(int arg_stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, 
		      boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, 
		      boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, 
		      String arg_postMemory, Method arg_execute, Method arg_successTest, 
		      Method arg_successTestSensorFactory, AblNamedPropertySupport arg_propertyTable)
    {
	super(arg_stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, 
	      arg_ignoreFailure, arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, 
	      arg_postMemory, arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable, MENTAL);
    }

    // Resets the step. Called when one wants to leave a step in the ABT but make it "fresh."
    void resetStep() 
    {
	if (valid == true) // mental step still valid
	    BehavingEntity.getBehavingEntity().resetStep(this);
    }

    void succeedStep() 
    {
	if (valid == true) // mental step still valid
	    super.succeedStep();
    }

    void failStep() 
    {
	if (valid == true) // mental step still valid
	    super.failStep();
    }

    void execute() {
	assert valid;

	final Object[] exeArgs = { new Integer(stepID), parent.getBehaviorVariableFrame(), 
				   BehavingEntity.getBehavingEntity(), this };
	try { 
	    execute.invoke(null, exeArgs);
	} 
	catch (InvocationTargetException e) { 
	    throw new AblRuntimeError("InvocationTargetException executing mental step in behavior " + parent + ". Error " + e.getCause(), e.getCause()); }
	catch (Exception e) {  throw new AblRuntimeError("Error executing mental step in behavior " + parent, e); }
	succeedStep();
    }

    // update node state so that it knows it's been deleted.
    // need this so that a mental step which ends up removing itself through reflection doesn't mess up on success
    void delete() { valid = false; }
}



