package abl.runtime;

/**
 * This is a generic bot launcher for ABL agents which need no special
 * sensorimotor inialization (or which have sensorimotor systems that
 * handle their own initialization). Currently only handles one agent
 * but can easily be changed to accomodate multiple agents if needed.
 *
 * @author sooraj
 */ 
public class LaunchAgent {
    public static void main(final String[] args) {
        try {
            Class clazz = Class.forName(args[0]);
            ((BehavingEntity)clazz.newInstance()).startBehaving();
        }
        catch (Throwable t) {
            System.err.println("usage: java abl.runtime.LaunchAgent foo.bar.AgentName\n");
            t.printStackTrace();
            System.exit(1);
        }
    }
}
