package abl.runtime;

import abl.compiler.AblDebuggerConstants;
import java.util.*;
import java.lang.reflect.Method;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.DefaultMutableTreeNode;

public class JointGoalStepDebug extends JointGoalStep implements DebuggableJointGoalStep, AblDebuggerConstants
{

    private final byte debugLevel; 

    // fixme: is this constructor used anymore? Seems like ASTGoalStep always explicitly sets the goal type.
    // Try commenting this out, do full build, and see what happens. 

    // Constructor for JointGoalStepDebug calls the super constructor. 
    public JointGoalStepDebug(int stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, 
			 boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, 
			 boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, 
			 String arg_postMemory, Method arg_execute, Method arg_successTest, 
			 Method arg_successTestSensorFactory, AblNamedPropertySupport arg_propertyTable, 
			 String arg_signature, String[] arg_stepsIConflictWith, boolean arg_teamNeededForSuccess, 
			 byte arg_debugLevel)
    {
	super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, arg_ignoreFailure, 
	      arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, 
	      arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable, arg_signature, 
	      arg_stepsIConflictWith, arg_teamNeededForSuccess);
	debugLevel = arg_debugLevel;
    }

    // This is the standard constructor - calls to this constructor are created by ASTGoalStep.
    public JointGoalStepDebug(int stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, 
			 boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, 
			 boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, 
			 String arg_postMemory, Method arg_execute, Method arg_successTest, 
			 Method arg_successTestSensorFactory, AblNamedPropertySupport arg_propertyTable, 
			 String arg_signature, String[] arg_stepsIConflictWith, short arg_goalType, 
			 boolean arg_teamNeededForSuccess, byte arg_debugLevel)
    {
	super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, arg_ignoreFailure, 
	      arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, 
	      arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable, arg_signature, 
	      arg_stepsIConflictWith, arg_goalType, arg_teamNeededForSuccess);
	debugLevel = arg_debugLevel;
    }

    // #################
    // Override getNewJointGoalNegotiator to provide a debug version of the negotiator.
    protected final JointGoalNegotiator getNewJointGoalNegotiator(Hashtable commitSet) 
    {
	return new JointGoalNegotiatorDebug(commitSet, debugLevel);
    }

    protected final JointGoalNegotiator getNewJointGoalNegotiator(Set teamMembers)
    {
	return new JointGoalNegotiatorDebug(teamMembers, this, debugLevel);
    }

    protected final JointGoalNegotiator getNewJointGoalNegotiator(Hashtable commitSet, int state)
    {
	return new JointGoalNegotiatorDebug(commitSet, state, debugLevel);
    }

    protected JointGoalNegotiator getNewJointGoalNegotiator(Set teamMembers, boolean newEntryNegotiation)
    {
	return new JointGoalNegotiatorDebug(teamMembers, newEntryNegotiation, this, debugLevel);
    }

    // JointGoalSteps check with parent to see if they should trace the negotiation event
    public final void traceAblNegotiationEvent(int type, JointGoalNegotiatorDebug.JointGoalNegotiationInfo info)
    {
	assert debugLevel == GUI_DEBUGGER; // this method should only be called when the GUI debugger is active.
	((DebuggableBehavior)parent).traceAblExecutionEvent(type, this, info, getNestLevel());
    }

    // #################
    
    // fixme: add trace support for suspend.

    final void execute() 
    {
	if (debugLevel == GUI_DEBUGGER)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUBGOAL_EXECUTION, this, null, getNestLevel());
	super.execute();
    }

    final void succeedStep() 
    {
	if (debugLevel == GUI_DEBUGGER)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUBGOAL_COMPLETION, this, new Boolean(true), getNestLevel());
	super.succeedStep();
    }

    final void failStep() 
    {
	if (debugLevel == GUI_DEBUGGER)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUBGOAL_COMPLETION, this, new Boolean(false), getNestLevel());
	super.failStep();
    }

    final boolean successTest()
    {
	final boolean ret = super.successTest();
	if (ret == true && debugLevel == GUI_DEBUGGER)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUCCESS_TEST_SUCCESS, this, null, getNestLevel());
	
	return ret;
    }

    // Returns a tree node which wraps the subtree rooted at this node in the ABT. 
    public final MutableTreeNode getTree() 
    {
	final DefaultMutableTreeNode node = new DefaultMutableTreeNode(this);
	if (child != null)
	    // If a behavior has been selected for this goal, add the tree
	    // rooted at this behavior. 
	    node.add(((DebuggableBehavior)child).getTree());
	
	return node;
    }

    // fixme: change this from a recursive call to an accessor for the nest level (see Behavior).
    // to do this, will need to reset the nest level when a goal spawns.
    public final int getNestLevel() {
	return ((DebuggableBehavior)parent).getNestLevel() + 1;
    }
}

