// Superclass for all joint behavior negotiation errors.

package abl.runtime;

public class JointGoalNegotiationError extends AblRuntimeError {
    public JointGoalNegotiationError(String s) { super(s); }

    protected static String stateName(int state)
    {
	switch(state) {
	case JointGoalNegotiator.START:
	    return "START";
	case JointGoalNegotiator.INTENTION_TO_ENTER:
	    return "INTENTION_TO_ENTER";
	case JointGoalNegotiator.INTENTION_TO_REFUSE_ENTRY:
	    return "INTENTION_TO_REFUSE_ENTRY";
	case JointGoalNegotiator.COMMIT_TO_ENTER:
	    return "COMMIT_TO_ENTER";
	case JointGoalNegotiator.COMMIT_TO_REFUSE_ENTRY:
	    return "COMMIT_TO_REFUSE_ENTRY";
	case JointGoalNegotiator.RUNNING: 
	    return "RUNNING";
	case JointGoalNegotiator.INTENTION_TO_SUCCEED: 
	    return "INTENTION_TO_SUCCEED";
	case JointGoalNegotiator.WAIT_FOR_SUCCESS:
	    return "WAIT_FOR_SUCCESS";
	case JointGoalNegotiator.COMMIT_TO_SUCCEED: 
	    return "COMMIT_TO_SUCCEED";
	case JointGoalNegotiator.INTENTION_TO_FAIL: 
	    return "INTENTION_TO_FAIL";
	case JointGoalNegotiator.COMMIT_TO_FAIL: 
	    return "COMMIT_TO_FAIL";
	case JointGoalNegotiator.INTENTION_TO_SUSPEND: 
	    return "INTENTION_TO_SUSPEND";
	case JointGoalNegotiator.COMMIT_TO_SUSPEND: 
	    return "COMMIT_TO_SUSPEND";
	case JointGoalNegotiator.SUSPENDED: 
	    return "SUSPENDED";
	case JointGoalNegotiator.INTENTION_TO_UNSUSPEND:
	    return "INTENTION_TO_UNSUSPEND";
	case JointGoalNegotiator.COMMIT_TO_UNSUSPEND: 
	    return "COMMIT_TO_UNSUSPEND";
	case JointGoalNegotiator.INTENTION_TO_REMOVE: 
	    return "INTENTION_TO_REMOVE";
	case JointGoalNegotiator.COMMIT_TO_REMOVE: 
	    return "COMMIT_TO_REMOVE";
   	default:
	    return "UNKNOWN_STATE";
	}
    }
}
