// Concrete debug class for initiated joint goal steps (initiated by another entity).

package abl.runtime;

import abl.compiler.AblDebuggerConstants;
import java.util.*;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.DefaultMutableTreeNode;

public class InitiatedJointGoalStepDebug extends InitiatedJointGoalStep implements DebuggableJointGoalStep, AblDebuggerConstants
{
    private final byte debugLevel;

    public InitiatedJointGoalStepDebug(Behavior beh, String signature, Set teamMembers, Object[] args, 
				       boolean teamNeededForSuccess, byte arg_debugLevel) 
    {
	super(beh, signature, teamMembers, args, teamNeededForSuccess);
	debugLevel = arg_debugLevel;
    }

    // #################
    // Override getNewJointGoalNegotiator to provide a debug version of the negotiator.
    protected final JointGoalNegotiator getNewJointGoalNegotiator(Hashtable commitSet) 
    {
	return new JointGoalNegotiatorDebug(commitSet, debugLevel);
    }

    protected final JointGoalNegotiator getNewJointGoalNegotiator(Set teamMembers)
    {
	return new JointGoalNegotiatorDebug(teamMembers, this, debugLevel);
    }

    protected final JointGoalNegotiator getNewJointGoalNegotiator(Hashtable commitSet, int state)
    {
	return new JointGoalNegotiatorDebug(commitSet, state, debugLevel);
    }

    protected JointGoalNegotiator getNewJointGoalNegotiator(Set teamMembers, boolean newEntryNegotiation)
    {
	return new JointGoalNegotiatorDebug(teamMembers, newEntryNegotiation, this, debugLevel);
    }

    // fixme: does this need public access?
    // JointGoalSteps check with parent to see if they should trace the negotiation event
    public final void traceAblNegotiationEvent(int type, JointGoalNegotiatorDebug.JointGoalNegotiationInfo info)
    {
	assert debugLevel == GUI_DEBUGGER; // this method only called when GUI debugger active
	((DebuggableBehavior)parent).traceAblExecutionEvent(type, this, info, getNestLevel());
    }

    // #################

    // fixme: add trace support for suspend

    final void execute() 
    {
	if (debugLevel == GUI_DEBUGGER)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUBGOAL_EXECUTION, this, null, getNestLevel());
	super.execute();
    }

    final void succeedStep() 
    {
	if (debugLevel == GUI_DEBUGGER)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUBGOAL_COMPLETION, this, new Boolean(true), getNestLevel());
	super.succeedStep();
    }

    final void failStep() 
    {
	if (debugLevel == GUI_DEBUGGER)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUBGOAL_COMPLETION, this, new Boolean(false), getNestLevel());
	super.failStep();
    }

    final boolean successTest()
    {
	final boolean ret = super.successTest();
	if (ret == true && debugLevel == GUI_DEBUGGER)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUCCESS_TEST_SUCCESS, this, null, getNestLevel());
	
	return ret;
    }

    // Returns a tree node which wraps the subtree rooted at this node in the ABT. 
    public final MutableTreeNode getTree() 
    {
	final DefaultMutableTreeNode node = new DefaultMutableTreeNode(this);
	if (child != null)
	    // If a behavior has been selected for this goal, add the tree
	    // rooted at this behavior. 
	    node.add(((DebuggableBehavior)child).getTree());
	
	return node;
    }

    // fixme: change this from a recursive call to an accessor for the nest level (see Behavior).
    // to do this, will need to reset the nest level when a goal spawns.
    public final int getNestLevel() {
	return ((DebuggableBehavior)parent).getNestLevel() + 1;
    }
}
