// Concrete class for initiated joint goal steps (initiated by another entity).

package abl.runtime;

import java.util.*;

public class InitiatedJointGoalStep extends JointGoalStep {

    private final static int INITIATED_JOINT_GOAL_STEP_ID = -4;

    private final Set teamMembers; 

    private final Object[] args;

    static private final short defaultPriority = 0;
    static private final short defaultPriorityModifier = 0;

    public InitiatedJointGoalStep(Behavior arg_parent, String arg_signature, Set arg_teamMembers, Object[] arg_args, 
				  boolean arg_teamNeededForSuccess) 
    { 
	// fixme: InitiatedJointGoalSteps should eventually take more properties from the initiating step.
	// parent constructor args (stepID, parent, persistent, persistentWhenSucceeds, persistentWhenFails, ignoreFailure, 
	// effectOnly, teamEffectOnly, priority, priorityModifier, post, postMemory, execute, successTest, 
	// bsuccessTestSensorFactory, propertyTable, signature, stepsIConflictWith, teamNeededForSuccess)

	super(INITIATED_JOINT_GOAL_STEP_ID, arg_parent, false, false, false, false, false, false, defaultPriority, 
	      defaultPriorityModifier, false, null, null, null, null, null, arg_signature, null, arg_teamNeededForSuccess);
	teamMembers = new HashSet(arg_teamMembers);
	args = arg_args;
	negotiator = new JointGoalNegotiator(teamMembers, this);
    }

    // When an InitiatedJointGoalStep is executed, it means that it's
    // original JointBehavior failed. In order for the
    // InitiatedJointGoalStep to not fail, it must find another
    // JointBehavior with the same team members and signature.
    void execute() 
    {
	final Behavior beh = BehavingEntity.getBehavingEntity().chooseJointBehavior(args, failedBehaviors, 
											 this, teamMembers);
	if (beh != null) {
	    addChild((Behavior)beh);
	    executeBookkeeping();
	}
	else
	    // No behavior found. Negotiate failure of the step.
	    failStep();
    }
}
