// WME wrapper for GoalSteps

package abl.runtime;

import java.beans.*;

public class GoalStepWME extends ExecutableStepWME
{
    protected BehaviorWME child = null; // WME wrapper for child behavior

    protected GoalChildChangeListener listener;

    private class GoalChildChangeListener implements PropertyChangeListener
    {
	GoalStepWME goalStepWME;
	
	GoalChildChangeListener(GoalStepWME g) { goalStepWME = g; }
	public void propertyChange(PropertyChangeEvent evt) {
	    assert (((evt.getOldValue() == null) || (evt.getNewValue() == null)) &&
		    ((evt.getOldValue() != null) || (evt.getNewValue() != null))); // old value == null xor new value == null
	    if (evt.getOldValue() == null) {
		// adding a new behavior child
		assert (goalStepWME.child == null); // if we're adding a child, then there currently shouldn't be a child
		Behavior newBehavior = (Behavior)evt.getNewValue();
		BehaviorWME newBehaviorWME = null;
		switch (newBehavior.getBehaviorType()) {
		case Behavior.ADAPTIVE:
		    /* Reflection on adaptive behaviors has not been defined yet */
		    throw new AblRuntimeError("Reflection on adaptive behaviors not implemented yet.");
		    //break;
		case Behavior.SEQUENTIAL:
		    newBehaviorWME = new SequentialBehaviorWME((SequentialBehavior)newBehavior, goalStepWME);
		    break;
		case Behavior.PARALLEL:
		    newBehaviorWME = new ParallelBehaviorWME((ParallelBehavior)newBehavior, goalStepWME);
		    break;
		case Behavior.COLLECTION:
		    newBehaviorWME = new CollectionBehaviorWME((CollectionBehavior)newBehavior, goalStepWME);
		    break;
		}
		goalStepWME.setChild(newBehaviorWME);
		BehavingEntity.getBehavingEntity().addWME(newBehaviorWME);
	    }
	    else {
		// removing a behavior child
		assert (goalStepWME.child != null); // if we're removing a child, then there should currently be child
		BehavingEntity.getBehavingEntity().deleteWME(goalStepWME.child);
		child.delete(); // update BehaviorWME state so it know it no longer wraps a valid ABT node
		goalStepWME.setChild(null);
	    }
	}
    }	
	

    // Doesn't set child. The child is set when a behavior is chosen to accomplish the goal
    public GoalStepWME(GoalStep goalStep, BehaviorWME parent)
    {
	super(goalStep, parent);
	listener = new GoalChildChangeListener(this);
	goalStep.addChildChangeListener(listener);
    }

    // Called when a GoalStepWME is removed from working memory. Removes the registered listener. 
    void delete() 
    {
	((GoalStep)s).removeChildChangeListener(listener); 
	super.delete();
    }

    public synchronized String getSignature() { return ((GoalStep)s).getSignature(); }
    public synchronized BehaviorWME getChild() { return child; }
    public synchronized boolean getIsExpanded() { return ((GoalStep)s).isExpanded(); }
    private synchronized void setChild(BehaviorWME b) { child = b; }

}
