package abl.runtime;

import javax.swing.tree.*;
import java.lang.reflect.Method;

public class GoalStepDebug extends GoalStep implements DebuggableStep {

    // Constructor for GoalStep calls the super constructor. 
    public GoalStepDebug(int stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, 
		    boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, 
		    boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, 
		    String arg_postMemory, Method arg_execute, Method arg_successTest, Method arg_successTestSensorFactory, 
		    AblNamedPropertySupport arg_propertyTable, String arg_signature, String[] arg_stepsIConflictWith)
    {
	super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, arg_ignoreFailure, 
	      arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, 
	      arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable, arg_signature, 
	      arg_stepsIConflictWith);
    }

    // Version of constructor for explicit set of goalExecutionType
    public GoalStepDebug(int stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, 
		    boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, 
		    boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, 
		    String arg_postMemory, Method arg_execute, Method arg_successTest, Method arg_successTestSensorFactory, 
		    AblNamedPropertySupport arg_propertyTable, String arg_signature, String[] arg_stepsIConflictWith,
		    short arg_goalExecutionType)
    {
	super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, arg_ignoreFailure, 
	      arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, 
	      arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable, arg_signature, 
	      arg_stepsIConflictWith, arg_goalExecutionType);
    }

    // fixme: add trace support for suspend.

    final void execute() 
    {
	((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUBGOAL_EXECUTION, this, null, getNestLevel());
	super.execute();
    }

    final void succeedStep() 
    {
	((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUBGOAL_COMPLETION, this, new Boolean(true), getNestLevel());
	super.succeedStep();
    }

    final void failStep() 
    {
	((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUBGOAL_COMPLETION, this, new Boolean(false), getNestLevel());
	super.failStep();
    }

    final boolean successTest()
    {
	final boolean ret = super.successTest();
	if (ret == true)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUCCESS_TEST_SUCCESS, this, null, getNestLevel());
	
	return ret;
    }

    // fixme: need to add debug cases for rerootGoal()

    // Returns a tree node which wraps the subtree rooted at this node in the ABT. 
    public final MutableTreeNode getTree() 
    {
	final DefaultMutableTreeNode node = new DefaultMutableTreeNode(this);
	if (child != null)
	    // If a behavior has been selected for this goal, add the tree
	    // rooted at this behavior. 
	    node.add(((DebuggableBehavior)child).getTree());
	
	return node;
    }

    // fixme: change this from a recursive call to an accessor for the nest level (see Behavior).
    // to do this, will need to reset the nest level when a goal spawns.
    public final int getNestLevel() {
	return ((DebuggableBehavior)parent).getNestLevel() + 1;
    }
}
