/*
 * Created on Jun 14, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package abl.runtime;

/**
 * @author mateas
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
class ExecutePolicyStep extends Step {

	private static final int EXECUTE_POLICY_STEP_ID = -100; 
	
	// Constructor sets the parent behavior. Since ExecutePolicyStep is only ever added to the ABT by 
	// the runtime, the constructor has default access and hardwires most of the constructor parameters.   
	 ExecutePolicyStep(Behavior arg_parent)
	 {
	 	super(EXECUTE_POLICY_STEP_ID, arg_parent, false, false, false, false, false, false, (short)0, (short)0, false, null, null, null, null, null, EXECUTE_POLICY);
	 }
	 
	/* (non-Javadoc)
	 * Execute the current bolicy on the parent adaptive behavior. This will result in selecting a step, 
	 * adding it as a child of the behavior, removing this step, and executing the policy-selected step. 
	 * @see abl.runtime.Step#execute()
	 */
	void execute() {
		// Remove from parent behavior. Perform appropriate mods on BehavingEntity.  
		// Removing ExecutePolicyStep assumes that the AdaptiveBehavior is sequential. If the AdaptiveBehavior is parellel, we'll want to leave the 
		// the ExecutePolicyStep in the tree so that multiple simultaneous steps can be sequenced. For now, let's just work with sequential AdaptiveBehaviors. 
		parent.removeChild(this, true); 

		// Execute the policy. Executing the policy selects a step, adds it as a child, and executes it. 
		((AdaptiveBehavior)parent).executePolicy(); 
	}

	/* (non-Javadoc)
	 * Reset the executePolicyStep.
	 * fixme: the call to BehavingEntity.resetStep() may be unnecessary for steps that execute atomically.
	 * It may be impossible for an ExecutePolicyStep to ever be reset, in which case throw an error. 
	 * But calling BehavingEntity.resetStep() should be harmless.   
	 * @see abl.runtime.Step#resetStep()
	 */
	void resetStep() {
		BehavingEntity.getBehavingEntity().resetStep(this);

	}

}
