// WME wrapper for ExecutableSteps

package abl.runtime;

public class ExecutableStepWME extends StepWME
{

    public ExecutableStepWME(Step step, BehaviorWME parent) { super(step, parent); }

    public synchronized String[] getConflicts() { return ((ExecutableStep)s).getConflicts(); }
    public synchronized boolean getIsExecuting() { return ((ExecutableStep)s).isExecuting(); }
    public synchronized boolean getIsSuspended() { return ((ExecutableStep)s).isSuspended(); }

    // ### Meta controls ###

    // Suspend the step. Only ExecutableSteps offer public access to metaSuspend
    public synchronized void suspend() 
    { 
	if (s != null)
	    ((ExecutableStep)s).metaSuspend(); 
    }
    
    // Unsuspend the step. Only ExecutableSteps offer public access to metaUnsuspend
    public synchronized void unsuspend() 
    {
	if (s != null)
	    ((ExecutableStep)s).metaUnsuspend(); 
    }

    // reset the step
    public synchronized void resetStep() 
    { 
	if (s != null)
	    ((ExecutableStep)s).resetStep(); 
    }
}
