package abl.runtime;

/** 
    A default implemenation for Sensor. Subclasses need only implement
    sense().  This is suitable for sensorimotor systems whose
    continuous and one-shot sensing can be done in the same way.

    This class is for asynchronous sensing.  One could easily write a
    synchronous version, that does no throttling via Thread.sleep().

    @author sooraj
 */
public abstract class DefaultAsyncSensor extends Sensor {

    public void senseOneShot(Object[] args) {
        sense(args);
    }

    public void initializeContinuous(Object[] args) {
        sense(args);
    }

    public void senseContinuous(Object[] args) {
        sense(args);
        slowDownContinuousSensing();
    }

    protected abstract void sense(Object[] args);

    /** Called by senseContinuous() to throttle asynchronous
        sensing. Necessary because async sensing has no external
        throttle (synchronous sensing is throttled by the ABL decision
        cycle). */
    protected void slowDownContinuousSensing() {
       try {
           Thread.sleep(33); // Slow down sense continuous since we're doing asynchronous sensing
       } 
       catch (InterruptedException e) { 
           throw new RuntimeError("Throttling for asynchronous sensing interrupted."); 
       }
    }
}


