// Debug support for watching the child of a sequential behavior
// This listener can be added to behaviors to help debug them.

package abl.runtime;
import java.beans.*;
// import debug.*;

public class DebugSequentialBehaviorChildChangeListener implements PropertyChangeListener
{
    SequentialBehavior b;

    public DebugSequentialBehaviorChildChangeListener(SequentialBehavior b) { this.b = b; }

    public void propertyChange(PropertyChangeEvent evt) {
	assert ((evt.getOldValue() == null) || (evt.getNewValue() == null)) &&
	    ((evt.getOldValue() != null) || (evt.getNewValue() != null)): "Behavior " + b; // old value == null xor new value == null
	if (evt.getOldValue() == null) {
	    // adding a step child

	    System.out.println("Adding child " + evt.getNewValue() + " to sequential behavior " + b.getSignature());
	    System.out.println("ignoreFailure = " + ((Step)evt.getNewValue()).getIgnoreFailure());
	    Thread.dumpStack();
	}
	else {
	    // remove a step child
	    
	    System.out.println("Removing child " + evt.getOldValue() + " from sequential behavior " + b.getSignature());

	    Thread.dumpStack();
	}
    }
}
