// Abstract WME for abl argument steps (acts, subgoals)
// fixme: change this into EpisodicArgumentActWME when temporal intervals are supported

package abl.runtime;

public abstract class CompletedExecutableStepWME extends CompletedStepWME {
	public final static int SUCCESS = 0;
	public final static int FAILURE = 1;
	
	private String signature;
	private int completionStatus; // SUCCESS or FAILURE
	
	// fixme: store arguments on acts and subgoals so that they are readily accessible
	// Object[] args; 
	
	public CompletedExecutableStepWME(String signature, int completionStatus, String behaviorSignature, String agent, long timestamp)
	{
		super(behaviorSignature, agent, timestamp);
		this.signature = signature;
		this.completionStatus = completionStatus;
	}
	
	public CompletedExecutableStepWME(String signature, int completionStatus, String behaviorSignature, String agent)
	{
		super(behaviorSignature, agent);
		this.signature = signature;
		this.completionStatus = completionStatus;
	}
	
	public synchronized String getSignature() { return signature; } 
	public synchronized void setSignature(String signature) { this.signature = signature; } 
	
	public synchronized int getCompletionStatus() { return completionStatus; }
	public synchronized void setCompletionStatus(int completionStatus) { this.completionStatus = completionStatus; }

}

