package abl.runtime;

import java.lang.reflect.Method;
import javax.swing.tree.MutableTreeNode;

public final class CollectionBehaviorDebug extends CollectionBehavior implements DebuggableBehavior { 

    private final BehaviorDebugSupport debugSupport; 

    private final __BehaviorDesc behaviorDesc; 

    public CollectionBehaviorDebug(GoalStep arg_parent, Method arg_contextCondition, 
		Method arg_contextConditionSensorFactory, Method arg_successCondition, 
				   Method arg_successConditionSensorFactory, boolean arg_isAtomic, String arg_signature, 
				   short arg_specificity, int arg_behaviorID, Object[] arg_behaviorVariableFrame, 
				   __StepDesc[] arg_stepDescs, int arg_numberNeededForSuccess, 
				   __BehaviorDesc arg_behaviorDesc) 
    {
		super(arg_parent, arg_contextCondition, arg_contextConditionSensorFactory,  
		   arg_successCondition, arg_successConditionSensorFactory, arg_isAtomic, arg_signature, 
	     arg_specificity, arg_behaviorID, arg_behaviorVariableFrame, arg_stepDescs, arg_numberNeededForSuccess);
       if (parent != null)
	   debugSupport = new BehaviorDebugSupport(this, ((DebuggableStep)parent).getNestLevel());
       else
	   debugSupport = new BehaviorDebugSupport(this, 0);
       behaviorDesc = arg_behaviorDesc;
    }

    public CollectionBehaviorDebug(GoalStep arg_parent, Method arg_contextCondition, 
		Method arg_contextConditionSensorFactory, Method arg_successCondition, 
				   Method arg_successConditionSensorFactory, boolean arg_isAtomic, String arg_signature, 
				   short arg_specificity, int arg_behaviorID, Object[] arg_behaviorVariableFrame, 
				   __StepDesc[] arg_stepDescs, int arg_numberNeededForSuccess, 
				   BehavingEntity[] arg_teamMembers, __BehaviorDesc arg_behaviorDesc) 
    {
		super(arg_parent, arg_contextCondition, arg_contextConditionSensorFactory,  
		   arg_successCondition, arg_successConditionSensorFactory, arg_isAtomic, arg_signature, 
	     arg_specificity, arg_behaviorID, arg_behaviorVariableFrame, arg_stepDescs, arg_numberNeededForSuccess, 
	     arg_teamMembers);
       if (parent != null)
	   debugSupport = new BehaviorDebugSupport(this, ((DebuggableStep)parent).getNestLevel());
       else
	   debugSupport = new BehaviorDebugSupport(this, 0);
       behaviorDesc = arg_behaviorDesc;
    }

    boolean contextCondition()
    {
	boolean b = super.contextCondition();
	if (!b) 
	    debugSupport.traceAblExecutionEvent(AblEvent.CONTEXT_CONDITION_FAILURE, behaviorDesc, null);

	return b;
    }

    void succeedBehavior() 
    {
	debugSupport.traceAblExecutionEvent(AblEvent.BEHAVIOR_COMPLETION, behaviorDesc, new Boolean(true));
	super.succeedBehavior();
    }

    void failBehavior()
    {
	debugSupport.traceAblExecutionEvent(AblEvent.BEHAVIOR_COMPLETION, behaviorDesc, new Boolean(false));
	super.failBehavior();
    }

    void addChildren()
    {
	debugSupport.traceAblExecutionEvent(AblEvent.BEHAVIOR_EXECUTION, behaviorDesc, parent);
	super.addChildren();

    }

    public final int getNestLevel() { return debugSupport.getNestLevel(); }
    public final MutableTreeNode getTree() { return debugSupport.getTree(); }
    public final void traceAblExecutionEvent(int type, Step source, Object obj, int nestLevel) 
    { 
	debugSupport.traceAblExecutionEvent(type, source, obj, nestLevel);
    }
}
