// Collection behavior
package abl.runtime;

import java.lang.reflect.Method;

public class CollectionBehavior extends MultiStepBehavior { 

    // Initialize behaviorType as a static variable shared by all collection behaviors. 
    protected static short behaviorType = Behavior.COLLECTION;

    public CollectionBehavior(GoalStep arg_parent, Method arg_contextCondition, Method arg_contextConditionSensorFactory, 
			      Method arg_successCondition, Method arg_successConditionSensorFactory, 
				  boolean arg_isAtomic, String arg_signature, short arg_specificity, int arg_behaviorID, 
			      Object[] arg_behaviorVariableFrame, __StepDesc[] arg_stepDescs, int arg_numberNeededForSuccess) 
    {
       super(arg_parent, arg_contextCondition, arg_contextConditionSensorFactory, 
		   arg_successCondition, arg_successConditionSensorFactory, arg_isAtomic, arg_signature, 
	     arg_specificity, arg_behaviorID, arg_behaviorVariableFrame, arg_stepDescs, arg_numberNeededForSuccess);
    }

    public CollectionBehavior(GoalStep arg_parent, Method arg_contextCondition, Method arg_contextConditionSensorFactory, 
			      Method arg_successCondition, Method arg_successConditionSensorFactory, 
				  boolean arg_isAtomic, String arg_signature, short arg_specificity, int arg_behaviorID, 
			      Object[] arg_behaviorVariableFrame, __StepDesc[] arg_stepDescs, int arg_numberNeededForSuccess,
			      BehavingEntity[] arg_teamMembers) 
    {
       super(arg_parent, arg_contextCondition, arg_contextConditionSensorFactory, 
		   arg_successCondition, arg_successConditionSensorFactory, arg_isAtomic, arg_signature, 
	     arg_specificity, arg_behaviorID, arg_behaviorVariableFrame, arg_stepDescs, arg_numberNeededForSuccess, 
	     arg_teamMembers);
    }

    // accessor for behaviorType.
    final short getBehaviorType() { return behaviorType; }

    // public accessor for initializing the root behavior - throws a runtime error if called on anything but the 
    // root behavior.
    public void initRootBehavior() 
    {
	if (parent != null) 
	    throw new AblRuntimeError("Attempt to call initRootBehavior() on a non-root behavior");
	else
	    addChildren();
    }
}
