// WME wrapper for behaviors.

package abl.runtime;

import java.util.*;
import wm.WME;
// import debug.Assert;

public class BehaviorWME extends WME 
{
    protected Behavior behavior; // The behavior wrapped by this WME
    protected GoalStepWME parent = null; // Wrapper for parent GoalStep
    protected boolean valid = true;
    
    public BehaviorWME(Behavior behavior, GoalStepWME parent) { 
	this.behavior = behavior; 
	this.parent = parent;
	behavior.setReflectionWME(this);
    }

    // ### Accessors ###
    
    public synchronized boolean getHasContextCondition() { return behavior.getHasContextCondition(); }
    
    public synchronized int getSpecificity() { return behavior.getSpecificity(); }
    public synchronized String getSignature() { return behavior.getSignature(); }
    public synchronized String getUniqSignature() { 
    	return behavior.getSignature() + "_" + getBehaviorID();
    }

    public synchronized GoalStepWME getParent() 
    { 
	assert (!behavior.isRootBehavior() && parent != null) || (behavior.isRootBehavior() && parent == null);
	return parent; 
    }

    public final synchronized int getBehaviorID() { return behavior.getBehaviorID(); }
    
    public synchronized int getBehaviorType() { return behavior.getBehaviorType(); }

    // accessors for named properties
    public synchronized Object getProperty(String name) { return behavior.propertyTable.getProperty(name); }
    public synchronized void setProperty(String name, Object value) { behavior.propertyTable.setProperty(name, value); }
    public synchronized void deleteProperty(String name) { behavior.propertyTable.deleteProperty(name); }
    public synchronized List getAllDefinedProperties() { return behavior.propertyTable.getAllDefinedProperties(); }

    // package accessor for the wrapped behavior. Accessible by the runtime but not user code. 
    synchronized Behavior getBehavior() 
    { 
	if (isValid()) 
	    return behavior; 
	else 
	    return null;
    }

    // return true if this BehaviorWME is still valid
    public synchronized boolean isValid() { return valid; }

    // returns true if the goal is recursively a parent of this behavior
    public synchronized boolean isParent(GoalStepWME parentGoal) 
    {
	if (parent == null)
	    return false; // nothing is the parent of the root collection behavior
	else if (parent == parentGoal) 
	    return true;
	else 
	    return parent.isParent(parentGoal);
    }

    // returns true if the behavior is recursively a parent of this behavior
    public synchronized boolean isParent(BehaviorWME parentBehavior) 
    {
	if (parent == null) 
	    return false; // nothing is the parent of the root collection behavior
	else 
	    return parent.isParent(parentBehavior);
    }

    // update BehaviorWME state so that it knows it no longer wraps a valid ABT node
    // package access - can only be called from within abl.runtime
    void delete() { valid = false; }

    public String toString() { return objectToString() + super.toString(); }
}
    

