// Comparator used to compare behavior specificities on __BehaviorDescs

package abl.runtime;

import java.util.Comparator;

class BehaviorSpecificityComparator implements Comparator {
 
    /* Compares the specificities of two behavior classes. 
       Returns value < 0 if o1.behDesc.specificity > o2.behDesc.specificity.
       Returns value = 0 if o1.behDesc.specificity = o2.behDesc.specificity.
       Returns value > 0 if o1.behDesc.specificity < o2.behDesc.specificity.
       Note: this comparator imposes orderings that are inconsitent with equals because
       it inherits equals from Object which tests for *reference* equality */
    public int compare(Object o1, Object o2) {
	final Integer i1 = new Integer(((SatisfiedBehavior)o1).behDesc.specificity);
	final Integer i2 = new Integer(((SatisfiedBehavior)o2).behDesc.specificity);
	return -i1.compareTo(i2);
    }
}
	
