/* Abstract superclass for debuggable behaviors (sequential, parallel and collection). */

package abl.runtime;

import javax.swing.tree.*;

class BehaviorDebugSupport {

    // the nest level is used by the debugger to nest the trace.
    private final int nestLevel;

    private final Behavior debuggedBehavior;

    private final BehavingEntity entity = BehavingEntity.getBehavingEntity(); // get a reference to this unique entity

    // fixme: remove - move this to the Debugger
    // private final static HashSet debuggedBehaviors = new HashSet();

    // fixme: remove -- move this to the debugger
    // private final static AblEventSupport listenerSupport = new AblEventSupport();

    BehaviorDebugSupport(Behavior arg_debuggedBehavior, int arg_nestLevel)
    {
	debuggedBehavior = arg_debuggedBehavior;
	nestLevel = arg_nestLevel;
    }

    int getNestLevel() { return nestLevel; }

    // Returns a tree node which wraps the subtree rooted at the debuggedBehavior in the ABT
    MutableTreeNode getTree() {
	final int behaviorType = debuggedBehavior.getBehaviorType();
	final DefaultMutableTreeNode node = new DefaultMutableTreeNode(debuggedBehavior);
	
	switch (behaviorType) {
	case Behavior.PARALLEL:
	case Behavior.COLLECTION:
	    final Step[] children = ((MultiStepBehavior)debuggedBehavior).getChildren();
	    for(int i = 0; i < children.length; i++)
		node.add(((DebuggableStep)children[i]).getTree());
	    return node;
	case Behavior.ADAPTIVE:
	    /* Debugging adaptive behaviors has not been defined yet */
	    throw new AblRuntimeError("Debugging adaptive behaviors not implemented yet.");
	    //break;
	case Behavior.SEQUENTIAL:	
	    final Step child = ((SequentialBehavior)debuggedBehavior).getChild();
	    node.add(((DebuggableStep)child).getTree());
	    return node;
	default:
	    throw new AblRuntimeError("Unexpected behavior type " + behaviorType); 
	}
    }

    // fixme: remove - move to debugger with interface on BehavingEntity
    // static void addBehaviorListener(AblListener behaviorListener) { listenerSupport.addAblListener(behaviorListener); }
    // static void removeBehaviorListener(AblListener behaviorListener) { listenerSupport.removeAblListener(behaviorListener); }

    void traceAblExecutionEvent(int type, Step source, Object obj, int nestLevel) 
    {
	entity.traceAblExecutionEvent(type, source, obj, nestLevel, debuggedBehavior.getID());
    }

    void traceAblExecutionEvent(int type, Step source, Object obj) 
    {
	entity.traceAblExecutionEvent(type, source, obj, nestLevel + 1, debuggedBehavior.getID());
    }

    void traceAblExecutionEvent(int type, __BehaviorDesc source, Object obj, int nestLevel) 
    {
	entity.traceAblExecutionEvent(type, source, obj, nestLevel, source.behaviorID);
    }

    void traceAblExecutionEvent(int type, __BehaviorDesc source, Object obj) 
    {
	entity.traceAblExecutionEvent(type, source, obj, nestLevel, source.behaviorID);
    }
    
    // fixme: remove
    /* void traceAblExecutionEvent(int type, Step source, Object obj, int nestLevel) 
    {
	if (debuggedBehaviors.contains(new Integer(debuggedBehavior.getID())))
	    listenerSupport.fireAblEvent(type, source, obj, nestLevel);
    }

    void traceAblExecutionEvent(int type, Step source, Object obj) 
    {
	if (debuggedBehaviors.contains(new Integer(debuggedBehavior.getID())))
	    listenerSupport.fireAblEvent(type, source, obj, nestLevel + 1);
    }

    static void traceAblExecutionEvent(int type, __BehaviorDesc source, Object obj, int nestLevel) 
    {
	if (debuggedBehaviors.contains(new Integer(source.behaviorID)))
	    listenerSupport.fireAblEvent(type, source, obj, nestLevel);
    }

    void traceAblExecutionEvent(int type, __BehaviorDesc source, Object obj) 
    {
	if (debuggedBehaviors.contains(new Integer(source.behaviorID)))
	    listenerSupport.fireAblEvent(type, source, obj, nestLevel + 1);
	    }*/

    // fixme: remove -- move this to Debugger
    // static void traceBehavior(int behaviorID) { debuggedBehaviors.add(new Integer(behaviorID)); }
    // static void untraceBehavior(int behaviorID) { debuggedBehaviors.remove(new Integer(behaviorID)); }
}
