package abl.runtime;

import java.util.Hashtable;
import java.util.Set;
/**
 * 
 * Interface for receiving notification of new decision cycles in ABL
 * 
 * @author Ben Weber
 */
public interface BehavingListener {

	/**
	 * Invoked at the start of each ABL decision cycle 
	 * 
	 * @param executingSteps - executing steps in the ABT
	 * @param leafSteps - leaf steps in the ABT
	 */
	public void onBehave(Hashtable executingSteps, Set leafSteps);
}
