// provides support for named properties on ABT nodes (goals and behaviors).

package abl.runtime;

import java.util.*;

// fixme: create a subclass of working memory that lives in abl.runtime that implements property support. 
public class AblNamedPropertySupport {
    private final Hashtable propertyTable = new Hashtable();

    public class UserProperty {
	private final String name;
	private final Object value;

	UserProperty(String n, Object v)
	{
	    name = n;
	    value = v;
	}
	
	public String getName() { return name; }
	public Object getValue() { return value; }
	
    }

    public void setProperty(String name, Object value) { propertyTable.put(name, value); }
    public Object getProperty(String name) { return propertyTable.get(name); }
    void deleteProperty(String name) { propertyTable.remove(name); }
    List getAllDefinedProperties() 
    {
	Vector propertyList = new Vector();

	Enumeration keys = propertyTable.keys();
	while(keys.hasMoreElements()) {
	    String propertyName = (String)keys.nextElement();
	    Object propertyValue = propertyTable.get(propertyName);
	    propertyList.add(new UserProperty(propertyName, propertyValue));
	}
	
	return propertyList;
    }
    
}
