// Provides support for registering AblListeners and firing AblEvents
package abl.runtime;

import java.util.Vector;

class AblEventSupport
{
    private Vector listeners = new Vector();

    private Object source;
    
    AblEventSupport() { source = null; }

    // source - the Object to be given as the source of this abl event
    AblEventSupport(Object source) { this.source = source; }

    void addAblListener(AblListener listener) { listeners.add(listener); }
    void removeAblListener(AblListener listener) { listeners.remove(listener); }
    
    void setSource(Object source) { this.source = source; }

    void fireAblEvent(int type, Object obj)
    {
	AblEvent e = new AblEvent(source, type, obj);
	for(int i = 0; i < listeners.size(); i++) 
	    ((AblListener) listeners.get(i)).eventHappened(e);
    }

    void fireAblEvent(int type, Object obj, int nestLevel)
    {
	AblEvent e = new AblEvent(source, type, obj, nestLevel);
	for(int i = 0; i < listeners.size(); i++) 
	    ((AblListener) listeners.get(i)).eventHappened(e);
    }

    void fireAblEvent(int type, Object source, Object obj, int nestLevel)
    {
	AblEvent e = new AblEvent(source, type, obj, nestLevel);
	for(int i = 0; i < listeners.size(); i++) 
	    ((AblListener) listeners.get(i)).eventHappened(e);
    }
}
	    
