// An event class for abl event notification.
package abl.runtime;

import java.util.EventObject;

public class AblEvent extends EventObject
{
    // precondition executed
    // object contains a Boolean indicating success or failure
    // source contains the behavior
    public static final int PRECONDITION_EXECUTION = 1; 

    // a behavior is added to the tree
    // object contains the goal the behavior is being chosen for
    // source contains behavior
    public static final int BEHAVIOR_EXECUTION = PRECONDITION_EXECUTION + 1;

    // a behavior is removed from the tree
    // object contains a Boolean indicating success or failure
    // source contains behavior
    public static final int BEHAVIOR_COMPLETION = BEHAVIOR_EXECUTION + 1;

    // a context condition failed
    // object is null
    // source contains the behavior
    public static final int CONTEXT_CONDITION_FAILURE = BEHAVIOR_COMPLETION + 1;

    // a physical act is executed 
    // object is null 
    // source contains physical act
    public static final int ACT_EXECUTION = CONTEXT_CONDITION_FAILURE + 1;

    // a physical act is removed from the tree
    // object contains a Boolean indicating success or failure
    // source contains physical act
    public static final int ACT_COMPLETION = ACT_EXECUTION + 1;
    
    // a subgoal step is executed
    // object is null
    // source contains the subgoal step
    public static final int SUBGOAL_EXECUTION = ACT_COMPLETION + 1;
    
    // subgoal step is removed from the tree
    // object contains a Boolean indicating success or failure
    // source contains the subgoal step 
    public static final int SUBGOAL_COMPLETION = SUBGOAL_EXECUTION + 1;

    // a mental step executes
    // object is null
    // source contains mental step
    public static final int MENTAL_STEP_EXECUTION = SUBGOAL_COMPLETION + 1;

    // a mental step is removed from the tree
    // object is null (mental steps always succeed)
    // source contains mental step
    public static final int MENTAL_STEP_COMPLETION = MENTAL_STEP_EXECUTION + 1;

    // a wait step is removed from the tree
    // this can only happen if the wait step has a success test associated with it; thus object is null
    // source contains wait step
    public static final int WAIT_STEP_COMPLETION = MENTAL_STEP_COMPLETION + 1;
    
    public static final int FAILSTEP_EXECUTION = WAIT_STEP_COMPLETION + 1;

    public static final int FAILSTEP_COMPLETION = FAILSTEP_EXECUTION + 1;

    public static final int SUCCEEDSTEP_EXECUTION = FAILSTEP_COMPLETION + 1;

    public static final int SUCCEEDSTEP_COMPLETION = SUCCEEDSTEP_EXECUTION + 1;

    // a step is suspended
    // object contains null
    // source contains the step
    public static final int STEP_SUSPENSION = SUCCEEDSTEP_COMPLETION + 1;

    // a step is unsuspended
    // object contains null
    // source contains the step
    public static final int STEP_UNSUSPENSION = STEP_SUSPENSION + 1;

    // a success test succeeds
    // object contains null
    // source contains step
    public static final int SUCCESS_TEST_SUCCESS = STEP_UNSUSPENSION + 1;

    // spawngoal reroots subgoal at root
    // object contains null
    // source contains the step
    public static final int SPAWNGOAL_AT_ROOT = SUCCESS_TEST_SUCCESS + 1;

    // negotiator initiates negotiation
    // object is JointGoalNegotiationInfo
    // source is the negotiator
    public static final int INITIATE_NEGOTIATION = SPAWNGOAL_AT_ROOT + 1;

    // negotiator completes negotiation
    // object is JointGoalNegotiationInfo
    // source is the negotiator
    public static final int COMPLETE_NEGOTIATION = INITIATE_NEGOTIATION + 1;

    // negotiator initiates intention
    // object is JointGoalNegotiationInfo
    // source is the negotiator
    public static final int INITIATE_INTENTION = COMPLETE_NEGOTIATION + 1;

    // negotiator commits to intention
    // object is JointGoalNegotiationInfo
    // source is the negotiator
    public static final int COMMIT_TO_INTENTION = INITIATE_INTENTION + 1;

    // negotiator completes intention
    // object is JointGoalNegotiationInfo
    // source is the negotiator
    public static final int PROCESS_INTENTION = COMMIT_TO_INTENTION + 1;

    // source types
    public static final int BEHAVIOR = 1;  // source type for behavior
    public static final int STEP = 2;      // source type for step
    public static final int NEGOTIATOR = 3; // source type for negotiator
   
    protected Object obj;
    protected int type; 
    protected int nestLevel = 0;
    protected long elapsedTime = -1; // if this is a completion event, elapsed time in milliseconds to complete

    public AblEvent(Object source, int type, Object obj)
    {
	super(source);
	this.type = type;
	this.obj = obj;
    }

    public AblEvent(Object source, int type, Object obj, int nestLevel)
    {
	super(source);
	this.type = type;
	this.obj = obj;
	this.nestLevel = nestLevel;
    }

    public int getType() { return type; }

    // fixme: getSourceType() isn't so useful now that different source types will have different 
    public int getSourceType() 
    {
	if (type == PRECONDITION_EXECUTION ||
	    type == BEHAVIOR_EXECUTION ||
	    type == BEHAVIOR_COMPLETION ||
	    type == CONTEXT_CONDITION_FAILURE)
	    return BEHAVIOR;
	else if (type == INITIATE_NEGOTIATION ||
		 type == COMPLETE_NEGOTIATION ||
		 type == INITIATE_INTENTION ||
		 type == COMMIT_TO_INTENTION ||
		 type == PROCESS_INTENTION)
	    return NEGOTIATOR;
	else
	    return STEP;
    }

    public Object getObject() { return obj; }

    public int getNestLevel() { return nestLevel; }
    
    public long getElapsedTime() { return elapsedTime; }

    // Set by Debugger
    void setElapsedTime(long t) { elapsedTime = t; }
    
    public String toString()
    {
	return "[AblEvent: type =" + type + "]";
    }
}

