package abl.compiler.util;

import fun.FoldL;
import fun.Fun2;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class StringUtil {

    /**
     * Chop a suffix from a string.
     * @param string the string
     * @param suffix the suffix
     * @return a new string with the suffix removed
     * @throws IllegalArgumentException if <code>string</code> does not have
     *         <code>suffix</code> as its suffix.
     */
    public static String chopSuffix(final String string, final String suffix) throws IllegalArgumentException {
        final String actualSuffix = string.substring(string.length() - suffix.length(),
                                                   string.length());
        if (actualSuffix.equals(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        } else {
            throw new IllegalArgumentException("String (" + string + ") does not have suffix "
                                               + suffix + ", instead it is " + actualSuffix);
        }
    }

    /**
     * Turn a string into its list of characters.
     */
    public static List<Character> explode(String s) {
        final List<Character> l = new ArrayList<Character>();
        final char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; i++) {
            l.add(new Character(chars[i]));
        }

        return l;
    }

    /**
     * Turn a list of characters into a string.
     */
    public static String implode(List<Character> charList) {
        final char[] chars = new char[charList.size()];
        Iterator<Character> iter = charList.iterator();
        for (int i = 0; i < chars.length; i++) {
            chars[i] = iter.next().charValue();
        }

        return new String(chars);
    }


    private static class AppendSBChar extends Fun2<StringBuilder, Character, StringBuilder> {
        @Override
        public StringBuilder apply(StringBuilder x, Character y) {
            return x.append(y);
        }
    }
}
