package abl.compiler.util;


public class Option<T> {
    
    public enum t {
        SOME, NONE
    }
    
    public final t type;
    private final T data;
    
    /**
     * Construct an option with data.
     * @param data the data
     */
    public Option(T data) {
        this.type = t.SOME;
        this.data = data;
    }
    
    /**
     * Construct an option without data.
     */
    public Option() {
        this.type = t.NONE;
        this.data = null;
    }
    
    public static <A> Option<A> none() {
        return new Option<A>();
    }
    
    /**
     * Construct an option with data.
     * @param <A> type of the data
     * @param object the data
     * @return the option
     */
    public static <A> Option<A> some(A object) {
        return new Option<A>(object);
    }
    
    public T getData() {
        switch (type) {
        case SOME:
            return data;
            
        default:
            throw new IllegalStateException("Option has no data.");
        }
    }

}
