package abl.compiler.util;

import java.util.ArrayList;
import java.util.Iterator;

public final class IteratorUtil {
    
    /**
     * Turn an iterator into an {@link ArrayList}.
     * @return a fresh {@link ArrayList}, with elements in the order they are
     *         returned by <code>ts</code>
     */
    public static <T> ArrayList<T> list(final Iterator<T> ts) {
        final ArrayList<T> ret = new ArrayList<T>();
        while (ts.hasNext()) {
            ret.add(ts.next());
        }
        
        return ret;
    }

}
