package abl.compiler.util;

import fun.Fun;
import fun.Fun2;
import java.util.Iterator;

// The following is derived from HOJ, but instead of returning null if the predicate doesn't match,
// it returns a NONE option. This is strictly more powerful; null may be what the predicate wants
// to find & thus indistinguishable from the null indicating no value matched.

public class FindOption<A> extends Fun2<Fun<? super A, Boolean>, Iterator<? extends A>, Option<A>> {

    public Option<A> apply(Fun<? super A, Boolean> p, Iterator<? extends A> xs) {
        while (xs.hasNext()) {
            A x = xs.next();
            if (p.apply(x))
                return new Option<A>(x);
        }
        return new Option<A>();
    }

    // FIXME: add static versions

}
