package abl.compiler.util;

import abl.compiler.Node;
import abl.compiler.ParseException;

/**
 * This interface is intended to be implemented by functors which frob an AST
 * node during the parsing process. This is specific to the parsing process
 * since it throws a {@link abl.compiler.ParseException}.
 * <p>
 * At the moment this class is only used by {@link abl.compiler.AblParser}.
 * @param <T> the concrete node type
 */
public interface ASTParseMutator<T extends Node> {

    /**
     * Mutate the node.
     * @param node the node
     * @throws ParseException if there is some sort of parse error in the node,
     *         which prevents mutating properly
     */
    void apply(T node) throws ParseException;
}
