package abl.compiler.astchecks;

import abl.compiler.ASTAblExpression;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTGoalStep;
import abl.compiler.Abl;
import abl.compiler.CompileException;
import abl.compiler.Node;
import abl.compiler.util.StringUtil;
import fun.Fun;
import java.io.File;

/**
 * Do type-checking on an ABL AST.
 * On Error, throw a {@link abl.compiler.CompileException}.
 */
public class TypeCheckVisitor extends IdentityASTVisitor {

    /**
     * Default ABL file extension. Used to make sure behavior unit named correctly.
     */
    public static final String DEFAULT_FILE_EXT = ".abl";


    private ASTBehaviorUnit unit = null;
    private final String origFilename;

    public TypeCheckVisitor(final ASTBehaviorUnit unit, final String origFilename) {
        this.unit = unit;
        this.origFilename = origFilename;
    }

    public Node visit(final ASTBehaviorUnit a) throws CompileException {
        filenameEqualsBehaviorUnitName(a.getBehavingEntityClass());
        return super.visit(a);
    }

    /**
     * Get the String type of an abl expression.
     */
    class ExpType extends Fun<ASTAblExpression, String> {
        public String apply(ASTAblExpression input) {
            try {
                assert unit != null;
                return input.getType(unit);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Node visit(final ASTGoalStep a) throws CompileException {
        // We want to check that the arguments to the goal step are of the correct type.
//        try {
//            System.err.println(Map.map(new ExpType(), a.getArgList().iterator()));
//        } catch (Exception e) {
//            throw new RuntimeException(e);
//        }

        return super.visit(a);
    }

    /****************************************************************************************/

    /*
     * NOTICE:
     *
     * It would be nice only to create methods in this class which implement one
     * type-checking test, and which are named for the test they do.
     * Utilities and other methods should go elsewhere. This will make the
     * Javadoc for this class particularly useful to read.
     */

    /**
     * Check that the name of the .abl file has the same prefix as the name of
     * the behavior unit.
     * @param behUnitName the name of the behavior unit
     * @throws CompileException if the names are different
     */
    public void filenameEqualsBehaviorUnitName(final String behUnitName) throws CompileException {
        final File f = new File(origFilename);
        final String targetName = StringUtil.chopSuffix(f.getName(), DEFAULT_FILE_EXT);
        if (!targetName.equals(behUnitName)) {
            throw new CompileException("Behavior unit (" + behUnitName + ") must have "
                                       + "same name as file (" + targetName + ")");
        }
    }

}
