// Abstract parse node for tests that can appear in conditions.

package abl.compiler;

import java.util.Set;

import jd.*;

abstract class TestNode extends AblParseNode {
    
    TestNode(int id) { super(id); }
    TestNode(AblParser p, int id) { super(p, id); }

	// Returns a set of the variables bound within the test. 
	abstract Set<String> getBoundVariables(); 
	
	// Returns a Set of the explicitly declared variables (declared in behavior or global?? scope) referenced by this test.
	abstract Set getExplicitlyDeclaredVariableReferences();
		
    abstract JavaCodeDescriptor compileToJava() throws CompileException;
}
