package abl.compiler;

import abl.compiler.astchecks.IdentityASTVisitor;
import java.io.PrintStream;
import java.util.Arrays;

public class PrinterVisitor extends IdentityASTVisitor {
    
    private PrintStream out;
    
    public PrinterVisitor(final PrintStream out) {
        this.out = out;
    }

    @Override
    public Node visit(ASTAblVariableDecl a) throws CompileException {
        out.print("var declaration : " + Arrays.asList(a.getFieldDescriptors()));
        return a;
    }

    @Override
    public Node visit(ASTActionRegistration a) throws CompileException {
        // TODO Auto-generated method stub
        return super.visit(a);
    }

}
