/* Interface defining macro definitions used in compiler */

package abl.compiler;

public interface MacroDefinitions {
    String eol = System.getProperty("line.separator");
    
    String sensorActivationMacroString =
	"definemacro sensorActivation(sensorClassName)" +
	"new SensorActivation(new sensorClassName(), null)";

    String behaviorUnitBehaviorRegistrationMacroString = 
	"definemacro behaviorUnitBehaviorRegistration(signature, signatures, behaviorID, factory, precondition, preconditionSensorFactory, teamMembers, specificity)" +
	"behaviorLibrary.registerBehavior(new __BehaviorDesc(behaviorID, factory, precondition, preconditionSensorFactory, \"signature\", signatures, teamMembers, (short)specificity));";

    String behaviorUnitBehaviorRegistrationCallMacroString = 
	"definemacro behaviorUnitBehaviorRegistrationCall(callCounter, behaviorLibrary)" + 
	"registerBehaviors_callCounter@(behaviorLibrary);";

    String behaviorUnitCodeMethodReflectionFieldNameMacroString =
	"definemacro behaviorUnitCodeMethodReflectionFieldName(codeMethodName)" +
	"__$codeMethodName@_rfield";

    String behaviorUnitInitCodeMethodReflectionFieldMacroString =
	"definemacro behaviorUnitInitCodeMethodReflectionField(methodFieldName, classFieldName, methodName, argArray)" +
	"methodFieldName = classFieldName.getDeclaredMethod(\"methodName\", argArray);";

    String behaviorUnitSetAssignableCodeMethodReflectionFieldMacroString =
	"definemacro behaviorUnitSetAssignableCodeMethodReflectionField(methodFieldName)" +
	"methodFieldName.setAccessible(true);";

    String behaviorUnitInitCodeClassReflectionFieldMacroString =
	"definemacro behaviorUnitInitCodeClassReflectionField(classFieldName, className, packageName)" +
	"classFieldName = Class.forName(\"packageName.className\");";

    String testExpressionSenseOneShotMacroString = 
	"definemacro testExpressionSenseOneShot(sensor)" +
	"sensor.getUniqueInstance().senseOneShot(null);";

    String wmeConstructorAssignmentMacroString = 
	"definemacro wmeConstructorAssignmentBlock(fieldName)" + 
	"this.fieldName = fieldName;";

    String wmeGetAccessorBodyMacroString = 
	"definemacro wmeGetAccessorBody(fieldName)" +
	"return fieldName;";

    String wmeSetAccessorBodyMacroString = 
	"definemacro wmeSetAccessorBody(fieldName)" +
	"this.fieldName = fieldName;";

    String wmeTestGetWMEListNoMemoryMacroString = 
	"definemacro wmeTestGetWMEListNoMemory(wmeCount, wmeClassName)" +
	"List wmeList@wmeCount;" + eol +
	"ListIterator wmeIter@wmeCount;" + eol +
	"wmeList@wmeCount = BehavingEntity.getBehavingEntity().lookupWME(\"wmeClassName\");" + eol + 
	"wmeIter@wmeCount = wmeList@wmeCount.listIterator();";

    String wmeTestGetWMEListMemoryMacroString =
	"definemacro wmeTestGetWMEListMemory(wmeCount, wmeClassName, memoryName)" +
	"List wmeList@wmeCount;" + eol +
	"ListIterator wmeIter@wmeCount;" + eol +
	"wmeList@wmeCount = WorkingMemory.lookupWME(\"memoryName\", \"wmeClassName\");" + eol +
	"wmeIter@wmeCount = wmeList@wmeCount.listIterator();";

    String wmeTestGetWMEListNoMemorySignatureOptMacroString = 
	"definemacro wmeTestGetWMEListNoMemorySigantureOpt(wmeCount, wmeClassName, signature)" +
	"List wmeList@wmeCount;" + eol +
	"ListIterator wmeIter@wmeCount;" + eol +
	"wmeList@wmeCount = BehavingEntity.getBehavingEntity().lookupReflectionWMEBySignature(\"wmeClassName\", signature);" + eol + 
	"wmeIter@wmeCount = wmeList@wmeCount.listIterator();";

    String wmeTestGetWMEListMemorySignatureOptMacroString =
	"definemacro wmeTestGetWMEListMemorySignatureOpt(wmeCount, wmeClassName, memoryName, signature)" +
	"List wmeList@wmeCount;" + eol +
	"ListIterator wmeIter@wmeCount;" + eol +
	"wmeList@wmeCount = WorkingMemory.lookupReflectionWMEBySignature(\"memoryName\", \"wmeClassName\", signature);" + eol +
	"wmeIter@wmeCount = wmeList@wmeCount.listIterator();";

    String wmeTestGetWMEListNoMemoryPropertyOptMacroString = 
	"definemacro wmeTestGetWMEListNoMemoryPropertyOpt(wmeCount, wmeClassName, propertyName)" +
	"List wmeList@wmeCount;" + eol +
	"ListIterator wmeIter@wmeCount;" + eol +
	"wmeList@wmeCount = BehavingEntity.getBehavingEntity().lookupReflectionWMEByUserProperty(\"wmeClassName\", \"propertyName\");" + eol + 
	"wmeIter@wmeCount = wmeList@wmeCount.listIterator();";

    String wmeTestGetWMEListMemoryPropertyOptMacroString =
	"definemacro wmeTestGetWMEListMemoryPropertyOpt(wmeCount, wmeClassName, memoryName, propertyName)" +
	"List wmeList@wmeCount;" + eol +
	"ListIterator wmeIter@wmeCount;" + eol +
	"wmeList@wmeCount = WorkingMemory.lookupReflectionWMEByUserProperty(\"memoryName\", \"wmeClassName\", \"propertyName\");" + eol +
	"wmeIter@wmeCount = wmeList@wmeCount.listIterator();";
	
    String wmeTestWhileMacroString = 
	"definemacro wmeTestWhile(wmeCount)" +
	"while(wmeIter@wmeCount.hasNext()) {";

    String wmeTestWhileNextAssignMacroString = 
	"definemacro wmeTestWhileNext(wmeCount, wmeClassName, wmeAssignVar)" +
	"wmeClassName wme__@wmeCount = (wmeClassName)wmeIter@wmeCount.next();" + eol +
	"wmeAssignVar = wme__@wmeCount;";

    String wmeTestWhileNextNoAssignMacroString = 
	"definemacro wmeTestWhileNext(wmeCount, wmeClassName)" +
	"wmeClassName wme__@wmeCount = (wmeClassName)wmeIter@wmeCount.next();";

    String ablEventSupportFieldInitializerMacroString = 
	"definemacro ablEventSupportFieldDef(classname)" +
	"_eventSupport = new AblEventSupport();" + eol +
	"try {" + eol +
	"    _eventSupport.setSource(Class.forName(\"classname\"));" + eol +
	"}" + eol +
	"catch (ClassNotFoundException e) { throw new RuntimeError(\"Reflection error initializing abl support \", e); }";
}
	
