package abl.compiler;

/**
 * Use this to issue warnings to the programmer when the compiler detects a
 * warning condition.
 */
public class CompileWarning {
    public static final String PREFIX = "Warning: ";
    public static final String LINE_PREFIX = "Warning on ";

    public static int warnCount = 0;

    public CompileWarning() {
    }

    public static void warn(String s) {
        warnCount++;
        System.out.println(PREFIX + s);
    }

    public static void warn(int lineNumber, String s) {
        warnCount++;
        System.out.println(LINE_PREFIX + "line " + lineNumber + ": " + s);
    }

}
