package abl.compiler;

/**
 * Thrown by the compiler to indicate that there is an error in compiling the
 * user's code.
 */
public class CompileException extends RuntimeException {
    public static final String PREFIX = "Error: ";
    public static final String LINE_PREFIX = "Error on ";

    public CompileException() {
        super();
    }

    public CompileException(String s) {
        super(PREFIX + s);
    }

    public CompileException(int lineNumber, String s) {
        super(LINE_PREFIX + "line " + lineNumber + ": " + s);
    }
}
