package abl.compiler;

import java.io.*;

/**
 * Thrown when an error inside the compiler is detected. This is as opposed to
 * an error in a file the compiler is compiling.
 */
public class CompileError extends Error {
    public CompileError() {
	super();
    }
    
    public CompileError(String s) {
	super(s);
    }

    public CompileError(String s, Throwable t) {
	super(fullErrorString(s, t));

    }

    protected static String fullErrorString(String s, Throwable t) {
	StringWriter tempWriter = new StringWriter();
	PrintWriter stackTrace = new PrintWriter(tempWriter);
	t.printStackTrace(stackTrace);
	return s + t.getMessage() + tempWriter;
    }
}



