/* Generated By:JJTree&JavaCC: Do not edit this line. AblParser.java */
package abl.compiler;

import jd.*;
import debug.*;
import java.util.*;
import abl.compiler.util.*;
import static abl.compiler.ParserErrorMessages.*;
import abl.runtime.GoalStep;

public class AblParser/*@bgen(jjtree)*/implements AblParserTreeConstants, AblParserConstants {/*@bgen(jjtree)*/
  protected JJTAblParserState jjtree = new JJTAblParserState();
    void jjtreeOpenNodeScope(Node n) {
        ((AblParseNode)n).firstToken = getToken(1);
    }

    void jjtreeCloseNodeScope(Node n) {
        ((AblParseNode)n).lastToken = getToken(0);
    }

  static final int[] GOALSTEP_TOKENS = { JOINT, SUBGOAL, SPAWNGOAL };
  static final int[] PRIMITIVESTEP_TOKENS = { ACT };
  static final int[] MENTALSTEP_TOKENS = { MENTAL_ACT };
  static final int[] MODIFYSTEP_TOKENS = { DELETE_STEP, ADD_STEP, MOVE_STEP };
  static final int[] ANONYMOUSSTEP_TOKENS = { SEQUENTIAL, PARALLEL, COLLECTION };
  static final int[] WAITSTEP_TOKENS = { WAIT };

  private boolean checkStepToken(Token tok, int[] stepType) {
        for(int i = 0; i < stepType.length; i++) {
                if (tok.kind == stepType[i]) {

                  // Comment in for debugging
                  /* final int line = tok.beginLine;
  		  if (stepType == GOALSTEP_TOKENS) 
  		  	System.out.println("Recognized a goal step at " + line);
  		  else if (stepType == PRIMITIVESTEP_TOKENS)
  		  	System.out.println("Recognized a primitive step at " + line);
  		  else if (stepType == MENTALSTEP_TOKENS)
  		  	System.out.println("Recognized a mental step at " + line);
  		  else if (stepType == MODIFYSTEP_TOKENS)
  		  	System.out.println("Recognized a modify step at " + line);
  		  else if (stepType == ANONYMOUSSTEP_TOKENS)
  		  	System.out.println("Recognized an anonymous step at " + line);
  		  else if (stepType == WAITSTEP_TOKENS)
  		  	System.out.println("Recognized a wait step at " + line);
  		  */

                  return true; // We found the step
                }
        }
        return false;
  }

  // Returns true if a step starting with one of the appropriate tokens in stepType is recognized.
  boolean isStep(int[] stepType) {
        int curTok = 1;

        // Comment in for debugging. 
        /*
	String stepTypeStr;
	if (stepType == GOALSTEP_TOKENS)
		stepTypeStr = "subgoal"; 
	else if (stepType == PRIMITIVESTEP_TOKENS) 
		stepTypeStr = "act";
	else if (stepType == MENTALSTEP_TOKENS) 
		stepTypeStr = "mental_act";
	else if (stepType == MODIFYSTEP_TOKENS) 
		stepTypeStr = "modify step";
	else if (stepType == ANONYMOUSSTEP_TOKENS) 
		stepTypeStr = "anonymous step";
	else if (stepType == WAITSTEP_TOKENS) 
		stepTypeStr = "wait";
	else
		stepTypeStr = "UNRECOGNIZED";
	System.out.println("Looking for " + stepTypeStr + " at line " + getToken(curTok).beginLine + " initial token " + tokenImage[getToken(curTok).kind]);
	*/

        if (getToken(curTok).kind == WITH) {
                int parenCounter = 0;

                // There are step annotations - move to the end of the annotations
                if (getToken(++curTok).kind == LPAREN)
                        parenCounter = 1;
                else
                        return false; // some kind of syntax error - this should be a parenthesis

                while(true) {
                        Token tok = getToken(++curTok);
                        if (tok.kind == LPAREN) parenCounter++;
                        if (tok.kind == RPAREN) parenCounter--;
                        if (tok.kind == SEMICOLON || tok.kind == EOF) return false; // Ran to the end of the line or the end of the file - no step recognized.  

                        if (parenCounter == 0) break;
                }
                return checkStepToken(getToken(++curTok), stepType);
        }
        else
                return checkStepToken(getToken(curTok), stepType);
  }

  // Returns true if this is a primitive type (or an array of primitive type) cast.
  boolean isPrimitiveTypeCast() {
    if (getToken(1).kind != LPAREN) return false;
    Token tok = getToken(2);
    switch (tok.kind) {
    case BOOLEAN:
    case CHAR:
    case BYTE:
    case SHORT:
    case INT:
    case LONG:
    case FLOAT:
    case DOUBLE:
      return true;
    }
    return false;
  }

  // Returns true if this is a type cast.
  boolean isTypeCast() {
    if (isPrimitiveTypeCast()) return true;
    if (getToken(1).kind != LPAREN) return false;
    int curTok = 2;
    Token tok = getToken(curTok++);
    if (tok.kind != IDENTIFIER) return false;
    while (true) {
      tok = getToken(curTok++);
      if (tok.kind != DOT) break;
      tok = getToken(curTok++);
      if (tok.kind != IDENTIFIER) return false;
    }
    if (tok.kind == RPAREN) {
      tok = getToken(curTok);
      switch (tok.kind) {
      case TILDE:
      case BANG:
      case LPAREN:
      case IDENTIFIER:
      case THIS:
      case SUPER:
      case NEW:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case TRUE:
      case FALSE:
      case NULL:
        return true;
      }
      return false;
    } else {
      if (tok.kind != LBRACKET) return false;
      tok = getToken(curTok);
      if (tok.kind != RBRACKET) return false;
      return true;
    }
  }

/****************************************
 * The ABL Language Grammar starts here *
 ****************************************/
  final public ASTBehaviorUnit BehaviorUnit() throws ParseException {
 /*@bgen(jjtree) BehaviorUnit */
        ASTBehaviorUnit jjtn000 = new ASTBehaviorUnit(JJTBEHAVIORUNIT);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);
        jjtreeOpenNodeScope(jjtn000);Token t;
        ASTJavaName n;
        String s;
    try {
      try {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PACKAGE:
          jj_consume_token(PACKAGE);
          n = Name();
                             jjtn000.behavingEntityPackage = n.dumpTokens();
          jj_consume_token(SEMICOLON);
          break;
        default:
          jj_la1[0] = jj_gen;
          ;
        }
        label_1:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IMPORT:
          case CONSTANTS:
            ;
            break;
          default:
            jj_la1[1] = jj_gen;
            break label_1;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IMPORT:
            s = ImportDeclaration();
                                   jjtn000.addUserImport(s);
            break;
          case CONSTANTS:
            s = ConstantDeclaration();
                                     jjtn000.addUserConstants(s);
            break;
          default:
            jj_la1[2] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(BEHAVING_ENTITY);
        t = AblName();
         jjtn000.setBehavingEntityClass(t.image);
        jj_consume_token(LBRACE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case JOINT_GOAL_SUCCESS_NEGOTIATION:
          TeamNeededForSuccessDefaultDeclaration(jjtn000);
          break;
        default:
          jj_la1[3] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DECISION_CYCLE_SM_CALL:
          DecisionCycleSMCallDeclaration(jjtn000);
          break;
        default:
          jj_la1[4] = jj_gen;
          ;
        }
        label_2:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case CONFLICT:
            ;
            break;
          default:
            jj_la1[5] = jj_gen;
            break label_2;
          }
          ConflictDeclaration(jjtn000);
        }
        label_3:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BOOLEAN:
          case BYTE:
          case CHAR:
          case DOUBLE:
          case FLOAT:
          case INT:
          case LONG:
          case SHORT:
          case PROPERTY:
          case REGISTER:
          case WME:
          case IDENTIFIER:
            ;
            break;
          default:
            jj_la1[6] = jj_gen;
            break label_3;
          }
          AblDeclaration(jjtn000);
        }
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ATOMIC:
          case COLLECTION:
          case JOINT:
          case PARALLEL:
          case SEQUENTIAL:
          case ADAPTIVE:
            ;
            break;
          default:
            jj_la1[7] = jj_gen;
            break label_4;
          }
          BehaviorDefinition();
        }
        label_5:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INITIAL_TREE:
            ;
            break;
          default:
            jj_la1[8] = jj_gen;
            break label_5;
          }
          InitialTree();
        }
        jj_consume_token(RBRACE);
        jj_consume_token(0);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtreeCloseNodeScope(jjtn000);
          {if (true) return jjtn000;}
      } catch (CompileException e) {
                                 {if (true) throw new ParseException(e.getMessage());}
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
    throw new Error("Missing return statement in function");
  }

  final public String ConstantDeclaration() throws ParseException {
 /*@bgen(jjtree) ConstantDeclaration */
  ASTConstantDeclaration jjtn000 = new ASTConstantDeclaration(JJTCONSTANTDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(CONSTANTS);
      Name();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        jj_consume_token(DOT);
        jj_consume_token(STAR);
        break;
      default:
        jj_la1[9] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtreeCloseNodeScope(jjtn000);
    {if (true) return jjtn000.dumpTokens(1, jjtn000.numberOfTokens() - 1);}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
    throw new Error("Missing return statement in function");
  }

  final public void ConflictDeclaration(ASTBehaviorUnit behUnit) throws ParseException {
    Token t;
    List conflictList = new Vector(100);
    jj_consume_token(CONFLICT);
    t = AblName();
                               conflictList.add(t.image);
    label_6:
    while (true) {
      t = AblName();
                                                                              conflictList.add(t.image);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_6;
      }
    }
    jj_consume_token(SEMICOLON);
      behUnit.registerConflictList(conflictList);
  }

  final public void PropertyDeclaration(ASTBehaviorUnit behUnit) throws ParseException {
 /*@bgen(jjtree) PropertyDeclaration */
    ASTPropertyDeclaration jjtn000 = new ASTPropertyDeclaration(JJTPROPERTYDECLARATION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);Token type;
    Token propertyName;
    try {
      jj_consume_token(PROPERTY);
                 ASTJavaType jjtn001 = new ASTJavaType(JJTJAVATYPE);
                 boolean jjtc001 = true;
                 jjtree.openNodeScope(jjtn001);
                 jjtreeOpenNodeScope(jjtn001);
      try {
        Type();
      } catch (Throwable jjte001) {
                 if (jjtc001) {
                   jjtree.clearNodeScope(jjtn001);
                   jjtc001 = false;
                 } else {
                   jjtree.popNode();
                 }
                 if (jjte001 instanceof RuntimeException) {
                   {if (true) throw (RuntimeException)jjte001;}
                 }
                 if (jjte001 instanceof ParseException) {
                   {if (true) throw (ParseException)jjte001;}
                 }
                 {if (true) throw (Error)jjte001;}
      } finally {
                 if (jjtc001) {
                   jjtree.closeNodeScope(jjtn001, true);
                   jjtreeCloseNodeScope(jjtn001);
                 }
      }
      propertyName = AblName();
      jj_consume_token(SEMICOLON);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtreeCloseNodeScope(jjtn000);
      jjtn000.setPropertyName(propertyName.image);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void AblDeclaration(ASTBehaviorUnit behUnit) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case IDENTIFIER:
      AblVariableDeclaration();
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[11] = jj_gen;
      if (jj_2_1(2)) {
        WMERegistration();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case REGISTER:
          ActionRegistration();
          break;
        case WME:
          WMEDeclaration();
          break;
        case PROPERTY:
          PropertyDeclaration(behUnit);
          break;
        default:
          jj_la1[12] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

/* Currently only handles WME registrations of the form 
   register wme <class name> with <sensor class>;
   Eventually may want to add support for registering WME's with
   field restrictions on specific sensors. */
  final public void WMERegistration() throws ParseException {
 /*@bgen(jjtree) WMERegistration */
   ASTWMERegistration jjtn000 = new ASTWMERegistration(JJTWMEREGISTRATION);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);
   jjtreeOpenNodeScope(jjtn000);Token t;
    try {
      jj_consume_token(REGISTER);
      jj_consume_token(WME);
      t = WMEClass();
     jjtn000.registeredWME = t.image;
      jj_consume_token(WITH);
      Name();
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtreeCloseNodeScope(jjtn000);
     }
    }
  }

  final public void ActionRegistration() throws ParseException {
 /*@bgen(jjtree) ActionRegistration */
    ASTActionRegistration jjtn000 = new ASTActionRegistration(JJTACTIONREGISTRATION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);Token t,n;
    try {
      jj_consume_token(REGISTER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ACT:
        jj_consume_token(ACT);
        break;
      case IDENTIFIER:
        n = AblName();
        if ( !"action".equals(n.image) ) {
            {if (true) throw new ParseException("Invalid registration syntax: register " + n.image);}
        }
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      t = AblName();
                      jjtn000.actionName = t.image;
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:
        t = AblSimpleType();
                                       jjtn000.addArgumentType(t.image);
        label_7:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[14] = jj_gen;
            break label_7;
          }
          jj_consume_token(COMMA);
          t = AblSimpleType();
                                                 jjtn000.addArgumentType(t.image);
        }
        break;
      default:
        jj_la1[15] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      jj_consume_token(WITH);
      Name();
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void BehaviorDefinition() throws ParseException {
 /*@bgen(jjtree) BehaviorDefinition */
    ASTBehaviorDefinition jjtn000 = new ASTBehaviorDefinition(JJTBEHAVIORDEFINITION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);Token t;
    String argType;
    String argName;
    try {
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ATOMIC:
        case JOINT:
        case ADAPTIVE:
          ;
          break;
        default:
          jj_la1[16] = jj_gen;
          break label_8;
        }
        BehaviorTypeModifier(jjtn000);
      }
      t = BehaviorType();
        jjtn000.setBehaviorType(t.image);
      jj_consume_token(BEHAVIOR);
      t = AblName();
        jjtn000.behaviorName = t.image;
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:
        t = AblSimpleType();
                                    argType = t.image;
        t = AblSimpleType();
                                    argName = t.image; jjtn000.addFormalArgument(new MethodArgDescriptor(argType, argName));
        label_9:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[17] = jj_gen;
            break label_9;
          }
          jj_consume_token(COMMA);
          t = AblSimpleType();
                                     argType = t.image;
          t = AblSimpleType();
                                     argName = t.image; jjtn000.addFormalArgument(new MethodArgDescriptor(argType, argName));
        }
        break;
      default:
        jj_la1[18] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      jj_consume_token(LBRACE);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CONTEXT_CONDITION:
        case ENTRY_CONDITION:
        case NUMBER_NEEDED_FOR_SUCCESS:
        case PRECONDITION:
        case SPECIFICITY:
        case TEAMMEMBERS:
        case R_SIGNAL:
        case STATE:
        case SUCCESS_CONDITION:
          ;
          break;
        default:
          jj_la1[19] = jj_gen;
          break label_10;
        }
        BehaviorModifiers(jjtn000);
      }
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FLOAT:
        case INT:
        case LONG:
        case SHORT:
        case IDENTIFIER:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_11;
        }
        AblVariableDeclaration();
        jj_consume_token(SEMICOLON);
      }
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ACT:
        case MENTAL_ACT:
        case COLLECTION:
        case FAIL:
        case JOINT:
        case PARALLEL:
        case SEQUENTIAL:
        case SPAWNGOAL:
        case SUBGOAL:
        case SUCCEED:
        case WAIT:
        case WITH:
        case MOVE_STEP:
        case DELETE_STEP:
        case ADD_STEP:
          ;
          break;
        default:
          jj_la1[21] = jj_gen;
          break label_12;
        }
        BehaviorStep();
      }
           if (jjtn000.isJoint() && !jjtn000.teamMembersSpecified())
              {if (true) throw new ParseException("Missing team member specifier for joint behavior " + jjtn000.getSignature());}
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void BehaviorModifiers(ASTBehaviorDefinition beh) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRECONDITION:
      Precondition(beh);
      break;
    case SPECIFICITY:
      Specificity(beh);
      break;
    case CONTEXT_CONDITION:
      ContextCondition(beh);
      break;
    case ENTRY_CONDITION:
      EntryCondition(beh);
      break;
    case NUMBER_NEEDED_FOR_SUCCESS:
      NumberNeededForSuccess(beh);
      break;
    case TEAMMEMBERS:
      TeamMemberSpecifier(beh);
      break;
    case SUCCESS_CONDITION:
      SuccessCondition(beh);
      break;
    case R_SIGNAL:
      ReinforcementSignals(beh);
      break;
    case STATE:
      ReinforcementState(beh);
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void Specificity(ASTBehaviorDefinition beh) throws ParseException {
   Token t;
    jj_consume_token(SPECIFICITY);
    t = jj_consume_token(INTEGER_LITERAL);
     if (beh.specificity == 0)
        beh.specificity = Integer.parseInt(t.image);
     else
        {if (true) throw new ParseException("Multiple specificity values for behavior " + beh.getSignature());}
    jj_consume_token(SEMICOLON);
  }

  final public void NumberNeededForSuccess(ASTBehaviorDefinition beh) throws ParseException {
   Token t;
    jj_consume_token(NUMBER_NEEDED_FOR_SUCCESS);
    t = jj_consume_token(INTEGER_LITERAL);
    jj_consume_token(SEMICOLON);
     if (beh.getBehaviorType().equals("sequential"))
        {if (true) throw new ParseException("number_needed_for_success defined on sequential behavior " + beh.getSignature());}
     int num = Integer.parseInt(t.image);
     if (num < 1)
        {if (true) throw new ParseException("the number_needed_for_success defined on sequential behavior " + beh.getSignature() + " must be >= 1");}
     beh.numberNeededForSuccess = num;
  }

  final public void TeamMemberSpecifier(ASTBehaviorDefinition beh) throws ParseException {
   Token t;
    jj_consume_token(TEAMMEMBERS);
     if (!beh.isJoint())
        {if (true) throw new ParseException("non-joint behavior " + beh.getSignature() + " has a team member specifier");}
     if (beh.teamMembersSpecified())
        {if (true) throw new ParseException("multiple team member specifiers appear on joint behavior " + beh.getSignature());}
    label_13:
    while (true) {
      t = jj_consume_token(IDENTIFIER);
                        beh.addRole(t.image);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[23] = jj_gen;
        break label_13;
      }
    }
    jj_consume_token(SEMICOLON);
  }

  final public void InitialTree() throws ParseException {
 /*@bgen(jjtree) BehaviorDefinition */
  ASTBehaviorDefinition jjtn000 = new ASTBehaviorDefinition(JJTBEHAVIORDEFINITION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(INITIAL_TREE);
      jj_consume_token(LBRACE);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ACT:
        case MENTAL_ACT:
        case COLLECTION:
        case FAIL:
        case JOINT:
        case PARALLEL:
        case SEQUENTIAL:
        case SPAWNGOAL:
        case SUBGOAL:
        case SUCCEED:
        case WAIT:
        case WITH:
        case MOVE_STEP:
        case DELETE_STEP:
        case ADD_STEP:
          ;
          break;
        default:
          jj_la1[24] = jj_gen;
          break label_14;
        }
        BehaviorStep();
      }
      jj_consume_token(RBRACE);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     jjtreeCloseNodeScope(jjtn000);
     jjtn000.setInitialTree();
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtreeCloseNodeScope(jjtn000);
     }
    }
  }

  final public Token BehaviorType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEQUENTIAL:
      jj_consume_token(SEQUENTIAL);
      break;
    case PARALLEL:
      jj_consume_token(PARALLEL);
      break;
    case COLLECTION:
      jj_consume_token(COLLECTION);
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return getToken(0);}
    throw new Error("Missing return statement in function");
  }

  final public void BehaviorTypeModifier(ASTBehaviorDefinition beh) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ATOMIC:
      jj_consume_token(ATOMIC);
       if (beh.isAtomic == true)
         // already set atomic - duplicate declaration
         {if (true) throw new ParseException("Duplicate atomic declaration for behavior " + beh.getSignature());}
       else
         beh.isAtomic = true;
      break;
    case JOINT:
      jj_consume_token(JOINT);
      if (beh.isJoint())
        // alread set joint - duplicate declaration
        {if (true) throw new ParseException("Duplicate joint modifier for behavior " + beh.getSignature());}
      else
         beh.setIsJoint();
      break;
    case ADAPTIVE:
      jj_consume_token(ADAPTIVE);
        if (beh.isAdaptive()) // already set adaptive - duplicate declaration
            {if (true) throw new ParseException("Duplicate adaptive modifier for behavior " + beh.getSignature());}
        else
            beh.setIsAdaptive();
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void Precondition(ASTBehaviorDefinition beh) throws ParseException {
    ASTTestExpression test;
    jj_consume_token(PRECONDITION);
    jj_consume_token(LBRACE);
    test = TestExpression();
    jj_consume_token(RBRACE);
       test.setTestType(ASTTestExpression.PRECONDITION);
       if (!beh.getHasPrecondition())
          beh.setHasPrecondition(true);
       else
          {if (true) throw new ParseException("Multiple preconditions for behavior " + beh.getSignature());}
  }

  final public ASTTestExpression TestExpression() throws ParseException {
 /*@bgen(jjtree) TestExpression */
    ASTTestExpression jjtn000 = new ASTTestExpression(JJTTESTEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);Token t;
    String defaultMemoryName = null;
    try {
      if (jj_2_2(2147483647)) {
        t = jj_consume_token(IDENTIFIER);
                                                             defaultMemoryName = t.image;
      } else {
        ;
      }
      label_15:
      while (true) {
        WMETestSequence(defaultMemoryName);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENTIFIER:
        case LPAREN:
        case LBRACE:
        case BANG:
          ;
          break;
        default:
          jj_la1[27] = jj_gen;
          break label_15;
        }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtreeCloseNodeScope(jjtn000);
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void DefaultMemoryLookahead() throws ParseException {
    jj_consume_token(IDENTIFIER);
    WMETestSequence(null);
  }

  final public void WMETestSequence(String defaultMemoryName) throws ParseException {
    Token memoryNameToken;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      jj_consume_token(LBRACE);
      memoryNameToken = jj_consume_token(IDENTIFIER);
      label_16:
      while (true) {
        if (jj_2_3(2147483647)) {
          WMETest(memoryNameToken.image);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
            jj_consume_token(LPAREN);
            ConditionalExpression();
            jj_consume_token(RPAREN);
            break;
          default:
            jj_la1[28] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENTIFIER:
        case LPAREN:
        case BANG:
          ;
          break;
        default:
          jj_la1[29] = jj_gen;
          break label_16;
        }
      }
      jj_consume_token(RBRACE);
      break;
    case IDENTIFIER:
    case LPAREN:
    case BANG:
      if (jj_2_4(2147483647)) {
        WMETest(defaultMemoryName);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          jj_consume_token(LPAREN);
          ConditionalExpression();
          jj_consume_token(RPAREN);
          break;
        default:
          jj_la1[30] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void WMETest(String memoryName) throws ParseException {
 /*@bgen(jjtree) WMETest */
    ASTWMETest jjtn000 = new ASTWMETest(JJTWMETEST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);Token t;
    ASTJavaName var;
    try {
      jjtn000.setMemoryName(memoryName);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BANG:
        jj_consume_token(BANG);
               jjtn000.negated = true;
        break;
      default:
        jj_la1[32] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        var = Name();
        jj_consume_token(ASSIGN);
                              jjtn000.wmeAssignmentVariable = var;
        break;
      default:
        jj_la1[33] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      t = WMEClass();
                              jjtn000.wmeClassName = t.image;
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENTIFIER:
          ;
          break;
        default:
          jj_la1[34] = jj_gen;
          break label_17;
        }
        WMEFieldTest();
      }
      jj_consume_token(RPAREN);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public Token WMEClass() throws ParseException {
    AblName();
      {if (true) return getToken(0);}
    throw new Error("Missing return statement in function");
  }

  final public void WMEFieldTest() throws ParseException {
 /*@bgen(jjtree) WMEFieldTest */
    ASTWMEFieldTest jjtn000 = new ASTWMEFieldTest(JJTWMEFIELDTEST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);Token t;
    ASTAblExpression n;
    try {
      t = jj_consume_token(IDENTIFIER);
                       jjtn000.wmeFieldName = t.image;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case V_BIND:
        jj_consume_token(V_BIND);
        break;
      case GT:
        jj_consume_token(GT);
        break;
      case LT:
        jj_consume_token(LT);
        break;
      case EQ:
        jj_consume_token(EQ);
        break;
      case LE:
        jj_consume_token(LE);
        break;
      case GE:
        jj_consume_token(GE);
        break;
      case NE:
        jj_consume_token(NE);
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                                           jjtn000.testOp = getToken(0).kind;
      // WME test operands can only be identifiers or literals. May need to change this to support full JavaNames. 
          // But if a test operand can be a JavaName, the WME test compilation code will need to be changed to support
          // appropriate scope references. 
          n = AblExpression();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtreeCloseNodeScope(jjtn000);
      jjtn000.wmeTestOperand = n;
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public Token AblLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case FLOATING_POINT_LITERAL:
      jj_consume_token(FLOATING_POINT_LITERAL);
      break;
    case DOUBLE_LITERAL:
      jj_consume_token(DOUBLE_LITERAL);
      break;
    case CHARACTER_LITERAL:
      jj_consume_token(CHARACTER_LITERAL);
      break;
    case STRING_LITERAL:
      jj_consume_token(STRING_LITERAL);
      break;
    case FALSE:
    case TRUE:
      BooleanLiteral();
      break;
    case NULL:
      NullLiteral();
      break;
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return getToken(0);}
    throw new Error("Missing return statement in function");
  }

  final public ASTAblExpression AblExpression() throws ParseException {
 /*@bgen(jjtree) AblExpression */
  ASTAblExpression jjtn000 = new ASTAblExpression(JJTABLEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        Name();
        break;
      case FALSE:
      case NULL:
      case TRUE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case DOUBLE_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
        AblLiteral();
        break;
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtreeCloseNodeScope(jjtn000);
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void ContextCondition(ASTBehaviorDefinition beh) throws ParseException {
    ASTTestExpression test;
    jj_consume_token(CONTEXT_CONDITION);
    jj_consume_token(LBRACE);
    test = TestExpression();
    jj_consume_token(RBRACE);
                test.setTestType(ASTTestExpression.CONTEXT_CONDITION);
                if (!beh.getHasContextCondition())
                        beh.setHasContextCondition(true);
                else
                        {if (true) throw new ParseException("Multiple context conditions for behavior " + beh.getSignature());}
  }

  final public void EntryCondition(ASTBehaviorDefinition beh) throws ParseException {
    ASTTestExpression test;
    jj_consume_token(ENTRY_CONDITION);
    jj_consume_token(LBRACE);
    test = TestExpression();
    jj_consume_token(RBRACE);
                test.setTestType(ASTTestExpression.ENTRY_CONDITION);
                if (!beh.getHasEntryCondition())
                        beh.setHasEntryCondition(true);
                else
                        {if (true) throw new ParseException("Multiple entry conditions for behavior " + beh.getSignature());}
  }

  final public void SuccessCondition(ASTBehaviorDefinition beh) throws ParseException {
    ASTTestExpression test;
    jj_consume_token(SUCCESS_CONDITION);
    jj_consume_token(LBRACE);
    test = TestExpression();
    jj_consume_token(RBRACE);
                test.setTestType(ASTTestExpression.SUCCESS_CONDITION);
                if (!beh.getHasSuccessCondition())
                        beh.setHasSuccessCondition(true);
                else
                        {if (true) throw new ParseException("Multiple success conditions for behavior " + beh.getSignature());}
  }

  final public void ReinforcementSignals(ASTBehaviorDefinition beh) throws ParseException {
 /*@bgen(jjtree) ReinforcementSignals */
  ASTReinforcementSignals jjtn000 = new ASTReinforcementSignals(JJTREINFORCEMENTSIGNALS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(R_SIGNAL);
      jj_consume_token(LBRACE);
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FALSE:
        case NULL:
        case TRUE:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case DOUBLE_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
          ;
          break;
        default:
          jj_la1[38] = jj_gen;
          break label_18;
        }
        ReinforcementSignal();
      }
      jj_consume_token(RBRACE);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtreeCloseNodeScope(jjtn000);
                if (!beh.getHasReinforcementSignals())
                        beh.setHasReinforcementSignals(true);
                else
                        {if (true) throw new ParseException("Multiple reinforcement signal blocks for behavior " + beh.getSignature());}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void ReinforcementSignal() throws ParseException {
    ASTAblExpression signalValue;
    ASTTestExpression test;
    signalValue = AblExpression();
    jj_consume_token(IF);
    jj_consume_token(LBRACE);
    test = TestExpression();
    jj_consume_token(RBRACE);
                test.setTestType(ASTTestExpression.REINFORCEMENT_TEST);
        test.setSignalValue(signalValue);
  }

  final public void ReinforcementState(ASTBehaviorDefinition beh) throws ParseException {
 /*@bgen(jjtree) ReinforcementState */
  ASTReinforcementState jjtn000 = new ASTReinforcementState(JJTREINFORCEMENTSTATE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(STATE);
      jj_consume_token(LBRACE);
      StateCondition(beh);
      label_19:
      while (true) {
        if (jj_2_5(1)) {
          ;
        } else {
          break label_19;
        }
        if (jj_2_6(2147483647)) {
          AblVariableDeclaration();
          jj_consume_token(SEMICOLON);
        } else if (jj_2_7(1)) {
          Statement();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      StateReturn(jjtn000);
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void StateCondition(ASTBehaviorDefinition beh) throws ParseException {
    ASTTestExpression test;
    jj_consume_token(LBRACE);
    test = TestExpression();
    jj_consume_token(RBRACE);
                test.setTestType(ASTTestExpression.STATE_CONDITION);
                if (!beh.getHasStateCondition())
                        beh.setHasStateCondition(true);
                else
                        {if (true) throw new ParseException("Multiple state conditions for behavior " + beh.getSignature());}
  }

  final public void StateReturn(ASTReinforcementState state) throws ParseException {
   ASTAblExpression tupleExp;
    jj_consume_token(STATE);
    jj_consume_token(RETURN);
    jj_consume_token(LPAREN);
    tupleExp = AblExpression();
                                     state.addTupleEntry(tupleExp);
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[39] = jj_gen;
        break label_20;
      }
      jj_consume_token(COMMA);
      tupleExp = AblExpression();
                                      state.addTupleEntry(tupleExp);
    }
    jj_consume_token(RPAREN);
    jj_consume_token(SEMICOLON);
  }

  final public void BehaviorStep() throws ParseException {
    // All the delayed step modifiers are stored in this collection.
    final List<ASTParseMutator<GenericStep>> fcns
        = new ArrayList<ASTParseMutator<GenericStep>>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ACT:
    case MENTAL_ACT:
    case COLLECTION:
    case JOINT:
    case PARALLEL:
    case SEQUENTIAL:
    case SPAWNGOAL:
    case SUBGOAL:
    case WAIT:
    case WITH:
    case MOVE_STEP:
    case DELETE_STEP:
    case ADD_STEP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
        jj_consume_token(WITH);
        jj_consume_token(LPAREN);
        StepModifier(fcns);
        label_21:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[40] = jj_gen;
            break label_21;
          }
          jj_consume_token(COMMA);
          StepModifier(fcns);
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[41] = jj_gen;
        ;
      }
      ModifiableStep(fcns);
      break;
    case FAIL:
      FailStep();
      break;
    case SUCCEED:
      SucceedStep();
      break;
    default:
      jj_la1[42] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ModifiableStep(Collection<ASTParseMutator<GenericStep>> fcns) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ACT:
      PrimitiveActStep(fcns);
      break;
    case MENTAL_ACT:
      MentalActStep(fcns);
      break;
    case JOINT:
    case SPAWNGOAL:
    case SUBGOAL:
      GoalStep(fcns);
      break;
    case MOVE_STEP:
    case DELETE_STEP:
    case ADD_STEP:
      ModifyStep(fcns);
      break;
    case COLLECTION:
    case PARALLEL:
    case SEQUENTIAL:
      AnonymousStep(fcns);
      break;
    case WAIT:
      WaitStep(fcns);
      break;
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void PrimitiveActStep(Collection<ASTParseMutator<GenericStep>> fcns) throws ParseException {
 /*@bgen(jjtree) PrimitiveStep */
    ASTPrimitiveStep jjtn000 = new ASTPrimitiveStep(JJTPRIMITIVESTEP);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);// Apply annotation settings to AST node.
    for (ASTParseMutator<GenericStep> f : fcns) {
        f.apply(jjtn000);
    }
    try {
      PrimitiveAct(jjtn000);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void MentalActStep(Collection<ASTParseMutator<GenericStep>> fcns) throws ParseException {
 /*@bgen(jjtree) MentalStep */
    ASTMentalStep jjtn000 = new ASTMentalStep(JJTMENTALSTEP);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);// Apply annotation settings to AST node.
    for (ASTParseMutator<GenericStep> f : fcns) {
        f.apply(jjtn000);
    }
    try {
      MentalAct();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void GoalStep(Collection<ASTParseMutator<GenericStep>> fcns) throws ParseException {
 /*@bgen(jjtree) GoalStep */
    ASTGoalStep jjtn000 = new ASTGoalStep(JJTGOALSTEP);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);// Apply annotation settings to AST node.
    for (ASTParseMutator<GenericStep> f : fcns) {
        f.apply(jjtn000);
    }
    try {
      Goal(jjtn000);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void WaitStep(Collection<ASTParseMutator<GenericStep>> fcns) throws ParseException {
 /*@bgen(jjtree) WaitStep */
    ASTWaitStep jjtn000 = new ASTWaitStep(JJTWAITSTEP);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);// Apply annotation settings to AST node.
    for (ASTParseMutator<GenericStep> f : fcns) {
        f.apply(jjtn000);
    }
    try {
      Wait();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void AnonymousStep(Collection<ASTParseMutator<GenericStep>> fcns) throws ParseException {
 /*@bgen(jjtree) AnonymousStep */
    ASTAnonymousStep jjtn000 = new ASTAnonymousStep(JJTANONYMOUSSTEP);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);// Apply annotation settings to AST node.
    for (ASTParseMutator<GenericStep> f : fcns) {
        f.apply(jjtn000);
    }
    try {
      AnonymousBlock(jjtn000);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void ModifyStep(Collection<ASTParseMutator<GenericStep>> fcns) throws ParseException {
 /*@bgen(jjtree) ModifyStep */
    ASTModifyStep jjtn000 = new ASTModifyStep(JJTMODIFYSTEP);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);final ASTJavaName n1, n2, n3, t3;
    final Token t1, t2;

    // Apply annotation settings to AST node.
    for (ASTParseMutator<GenericStep> f : fcns) {
        f.apply(jjtn000);
    }
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MOVE_STEP:
        jj_consume_token(MOVE_STEP);
        n1 = Name();
        t1 = jj_consume_token(INTEGER_LITERAL);
        // from X
                         n2 = Name();
        t2 = jj_consume_token(INTEGER_LITERAL);
        // before/after Y
                         n3 = Name();
        t3 = Name();
        jj_consume_token(SEMICOLON);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtreeCloseNodeScope(jjtn000);
        jjtn000.modifyType = ASTModifyStep.MOVESTEP;
        if (   !n1.getFullName().equals("from")
            || !(   n2.getFullName().equals("before")
                 || n2.getFullName().equals("after"))
            || !n3.getFullName().equals("in"))
        {
            {if (true) throw new ParseException("invalid move_step syntax (move_step from X before/after Y in Z)");}
        }
        jjtn000.fromIndex = Integer.valueOf(t1.image).intValue();
        jjtn000.toIndex = Integer.valueOf(t2.image).intValue();
        if (n2.getFullName().equals("after"))
            jjtn000.toAfter = true;
        else
            jjtn000.toAfter = false;
        jjtn000.inBehavior = t3;
        break;
      case DELETE_STEP:
        jj_consume_token(DELETE_STEP);
        n1 = Name();
        t1 = jj_consume_token(INTEGER_LITERAL);
        // from X
                           n3 = Name();
        t3 = Name();
        jj_consume_token(SEMICOLON);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtreeCloseNodeScope(jjtn000);
        jjtn000.modifyType = ASTModifyStep.DELETESTEP;
        if (   !n1.getFullName().equals("from")
            || !n3.getFullName().equals("in"))
        {
            {if (true) throw new ParseException("invalid delete_step syntax (delete_step from X in Z)");}
        }
        jjtn000.fromIndex = Integer.valueOf(t1.image).intValue();
        jjtn000.inBehavior = t3;
        break;
      case ADD_STEP:
        jj_consume_token(ADD_STEP);
        n2 = Name();
        t2 = jj_consume_token(INTEGER_LITERAL);
        // before/after T
                        n3 = Name();
        t3 = Name();
        BehaviorStep();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtreeCloseNodeScope(jjtn000);
        jjtn000.modifyType = ASTModifyStep.ADDSTEP;
        if (   !(   n2.getFullName().equals("before")
                 || n2.getFullName().equals("after"))
            || !n3.getFullName().equals("in"))
        {
            {if (true) throw new ParseException("invalid add_step syntax (add_step before/after Y in Z BehaviorStep)");}
        }
        jjtn000.toIndex = Integer.valueOf(t2.image).intValue();
        if (n2.getFullName().equals("after"))
            jjtn000.toAfter = true;
        else
            jjtn000.toAfter = false;
        jjtn000.inBehavior = t3;
        break;
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void FailStep() throws ParseException {
 /*@bgen(jjtree) FailStep */
  ASTFailStep jjtn000 = new ASTFailStep(JJTFAILSTEP);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(FAIL);
      jj_consume_token(SEMICOLON);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtreeCloseNodeScope(jjtn000);
     }
    }
  }

  final public void SucceedStep() throws ParseException {
 /*@bgen(jjtree) SucceedStep */
  ASTSucceedStep jjtn000 = new ASTSucceedStep(JJTSUCCEEDSTEP);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(SUCCEED);
      jj_consume_token(SEMICOLON);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtreeCloseNodeScope(jjtn000);
     }
    }
  }

  final public void AnonymousBlock(ASTAnonymousStep as) throws ParseException {
        Token t;
    t = BehaviorType();
                as.setBehaviorType(t.image);
    jj_consume_token(LBRACE);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[45] = jj_gen;
        break label_22;
      }
      AblVariableDeclaration();
      jj_consume_token(SEMICOLON);
    }
    label_23:
    while (true) {
      BehaviorStep();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ACT:
      case MENTAL_ACT:
      case COLLECTION:
      case FAIL:
      case JOINT:
      case PARALLEL:
      case SEQUENTIAL:
      case SPAWNGOAL:
      case SUBGOAL:
      case SUCCEED:
      case WAIT:
      case WITH:
      case MOVE_STEP:
      case DELETE_STEP:
      case ADD_STEP:
        ;
        break;
      default:
        jj_la1[46] = jj_gen;
        break label_23;
      }
    }
    jj_consume_token(RBRACE);
  }

  final public void StepModifier(Collection<ASTParseMutator<GenericStep>> fcns) throws ParseException {
    final Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUCCESS_TEST:
      SuccessTest(fcns);
      break;
    case PRIORITY:
    case PRIORITY_MODIFIER:
      PriorityModifier(fcns);
      break;
    case IGNORE_FAILURE:
      jj_consume_token(IGNORE_FAILURE);
        fcns.add(new ASTParseMutator<GenericStep>() {
                public void apply(final GenericStep s) {
                    s.ignoreFailure = true;
                }
            });
      break;
    case PERSISTENT:
      Persistence(fcns);
      break;
    case EFFECT_ONLY:
      jj_consume_token(EFFECT_ONLY);
        fcns.add(new ASTParseMutator<GenericStep>() {
                public void apply(final GenericStep s) {
                    s.effectOnly = true;
                }
            });
      break;
    case TEAM_EFFECT_ONLY:
      jj_consume_token(TEAM_EFFECT_ONLY);
        fcns.add(new ASTParseMutator<GenericStep>() {
                public void apply(final GenericStep s) {
                    s.teamEffectOnly = true;
                }
            });
      break;
    case PROPERTY:
      NamedProperty(fcns);
      break;
    case POST:
      jj_consume_token(POST);
        fcns.add(new ASTParseMutator<GenericStep>() {
                public void apply(final GenericStep s) throws ParseException {
                    if (s.getPost()) {
                        {if (true) throw new ParseException(ONLY_ONE_POST.getMsg());}
                    }
                    s.setPost(true);
                }
            });
      break;
    case POST_TO:
      jj_consume_token(POST_TO);
      t = jj_consume_token(IDENTIFIER);
        fcns.add(new ASTParseMutator<GenericStep>() {
                public void apply(final GenericStep s) throws ParseException {
                    if (null == s.getPostMemory()) {
                        s.setPostMemory(t.image);
                    } else {
                        {if (true) throw new ParseException(ONLY_ONE_POST_TO.getMsg());}
                    }
                }
            });
      break;
    case ONE_NEEDED_FOR_SUCCESS:
      t = jj_consume_token(ONE_NEEDED_FOR_SUCCESS);
        fcns.add(new ASTParseMutator<GenericStep>() {
                public void apply(final GenericStep s) throws ParseException {
                    if (s instanceof ASTGoalStep) {
                        ((ASTGoalStep) s).setTeamNeededForSuccess(false);
                    } else {
                        {if (true) throw new ParseException(GOAL_ANNOTATION_IN_OTHER_STEP.getMsg()
                                                 + ": " + t.image);}
                    }
                }
            });
      break;
    case TEAM_NEEDED_FOR_SUCCESS:
      t = jj_consume_token(TEAM_NEEDED_FOR_SUCCESS);
        fcns.add(new ASTParseMutator<GenericStep>() {
                public void apply(final GenericStep s) throws ParseException {
                    if (s instanceof ASTGoalStep) {
                        ((ASTGoalStep) s).setTeamNeededForSuccess(true);
                    } else {
                        {if (true) throw new ParseException(GOAL_ANNOTATION_IN_OTHER_STEP.getMsg()
                                                 + ": " + t.image);}
                    }
                }
            });
      break;
    default:
      jj_la1[47] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void SuccessTest(Collection<ASTParseMutator<GenericStep>> fcns) throws ParseException {
    final ASTTestExpression test;
    jj_consume_token(SUCCESS_TEST);
    jj_consume_token(LBRACE);
    test = TestExpression();
    jj_consume_token(RBRACE);
        assert jjtree.nodeCreated();
        // Remove the ASTTestExpression node from the stack so it doesn't
        // get added as a child to any other node by JJTree. A success_test
        // ASTTextExpression node must be a child of the AST node for the
        // step we get through the ASTParseMutator (below).
        jjtree.popNode();

        fcns.add(new ASTParseMutator<GenericStep>() {
                public void apply(final GenericStep s) throws ParseException {
                    if (!s.hasSuccessTest) {
                        s.hasSuccessTest = true;
                        test.setTestType(ASTTestExpression.SUCCESS_TEST);
                        // Success tests have nodes & they have to be added
                        // as a child of the step they modify.
                        // TODO: Does this work?
                        jjtree.pushNode(test);
                        //s.jjtAddChild(test, s.jjtGetNumChildren());
                        //test.jjtSetParent(s);
                    }
                    else {
                        {if (true) throw new ParseException(ONLY_ONE_SUCCESS_TEST.getMsg());}
                    }
                }
            });
  }

  final public void PriorityModifier(Collection<ASTParseMutator<GenericStep>> fcns) throws ParseException {
    final Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIORITY_MODIFIER:
      jj_consume_token(PRIORITY_MODIFIER);
      t = jj_consume_token(INTEGER_LITERAL);
        fcns.add(new ASTParseMutator<GenericStep>() {
                public void apply(final GenericStep s) throws ParseException {
                    s.priorityModifier = Integer.parseInt(t.image);
                }
            });
      break;
    case PRIORITY:
      jj_consume_token(PRIORITY);
      t = jj_consume_token(INTEGER_LITERAL);
        fcns.add(new ASTParseMutator<GenericStep>() {
                public void apply(final GenericStep s) throws ParseException {
                    s.priority = Integer.parseInt(t.image);
                }
            });
      break;
    default:
      jj_la1[48] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void Persistence(Collection<ASTParseMutator<GenericStep>> fcns) throws ParseException {
    final Token t;
    if (jj_2_8(2)) {
      jj_consume_token(PERSISTENT);
      t = PersistenceType();
        fcns.add(new ASTParseMutator<GenericStep>() {
                public void apply(final GenericStep s) throws ParseException {
                    if (t.kind == WHEN_SUCCEEDS)
                        s.persistentWhenSucceeds = true;
                    else if (t.kind == WHEN_FAILS)
                        s.persistentWhenFails = true;
                }
            });
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PERSISTENT:
        jj_consume_token(PERSISTENT);
        fcns.add(new ASTParseMutator<GenericStep>() {
                public void apply(final GenericStep s) throws ParseException {
                    s.persistent = true;
                }
            });
        break;
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void NamedProperty(Collection<ASTParseMutator<GenericStep>> fcns) throws ParseException {
    final Token propertyName;
    final ASTAblExpression propertyValue;
    jj_consume_token(PROPERTY);
    propertyName = AblName();
    propertyValue = AblExpression();
       assert jjtree.nodeCreated();
       jjtree.popNode();
        // Remove the ASTAblExpression node from the stack so it doesn't
        // get added as a child to any other node by JJTree. A
        // namedproperty ASTTextExpression node must be a child of the AST
        // node for the step we get through the ASTParseMutator (below).

       fcns.add(new ASTParseMutator<GenericStep>() {
               public void apply(final GenericStep s) throws ParseException {
                   try {
                       s.setProperty(propertyName.image, propertyValue);
                       s.jjtAddChild(propertyValue, s.jjtGetNumChildren());
                       propertyValue.jjtSetParent(s);
                   } catch (CompileException e) {
                       {if (true) throw new ParseException(e.getMessage());}
                   }
               }
           });
  }

  final public Token PersistenceType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHEN_FAILS:
      jj_consume_token(WHEN_FAILS);
      break;
    case WHEN_SUCCEEDS:
      jj_consume_token(WHEN_SUCCEEDS);
      break;
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return getToken(0);}
    throw new Error("Missing return statement in function");
  }

  final public void PrimitiveAct(ASTPrimitiveStep s) throws ParseException {
   ASTAblExpression n;
   Token t;
    jj_consume_token(ACT);
    t = AblName();
                          s.actName = t.image;
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case DOUBLE_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
      n = AblExpression();
                                        s.addArgument(n);
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[51] = jj_gen;
          break label_24;
        }
        jj_consume_token(COMMA);
        n = AblExpression();
                                                 s.addArgument(n);
      }
      break;
    default:
      jj_la1[52] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    jj_consume_token(SEMICOLON);
  }

  final public void MentalAct() throws ParseException {
    jj_consume_token(MENTAL_ACT);
    jj_consume_token(LBRACE);
    label_25:
    while (true) {
      if (jj_2_9(1)) {
        ;
      } else {
        break label_25;
      }
      if (jj_2_10(2147483647)) {
        AblVariableDeclaration();
        jj_consume_token(SEMICOLON);
      } else if (jj_2_11(1)) {
        Statement();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
  }

  final public void Goal(ASTGoalStep s) throws ParseException {
    ASTAblExpression n;
    Token t;
    ASTJavaName rerootParent;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case JOINT:
      jj_consume_token(JOINT);
                s.setJointGoal();
      break;
    default:
      jj_la1[53] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUBGOAL:
      jj_consume_token(SUBGOAL);
        s.setGoalExecutionType(GoalStep.SUBGOAL);
      break;
    case SPAWNGOAL:
      jj_consume_token(SPAWNGOAL);
        s.setGoalExecutionType(GoalStep.SPAWNGOAL_DEFAULT);
      break;
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = AblName();
                    s.goalName = t.image;
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case DOUBLE_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
      n = AblExpression();
                               s.addArgument(n);
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[55] = jj_gen;
          break label_26;
        }
        jj_consume_token(COMMA);
        n = AblExpression();
                                       s.addArgument(n);
      }
      break;
    default:
      jj_la1[56] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
      jj_consume_token(AT);
      rerootParent = Name();
        if (s.getGoalExecutionType() != GoalStep.SPAWNGOAL_DEFAULT) {if (true) throw new ParseException("Behavior parent specified for a non-spawngoal");}
        s.setRerootParent(rerootParent);
        s.setGoalExecutionType(GoalStep.SPAWNGOAL_AT_NODE);
      break;
    default:
      jj_la1[57] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
  }

  final public void Wait() throws ParseException {
    jj_consume_token(WAIT);
    jj_consume_token(SEMICOLON);
  }

  final public void AblVariableDeclaration() throws ParseException {
 /*@bgen(jjtree) AblVariableDecl */
  ASTAblVariableDecl jjtn000 = new ASTAblVariableDecl(JJTABLVARIABLEDECL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      ASTJavaType jjtn001 = new ASTJavaType(JJTJAVATYPE);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      jjtreeOpenNodeScope(jjtn001);
      try {
        Type();
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
        jjtreeCloseNodeScope(jjtn001);
      }
      }
      VariableDeclarator();
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[58] = jj_gen;
          break label_27;
        }
        jj_consume_token(COMMA);
        VariableDeclarator();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public Token AblSimpleType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
      PrimitiveType();
      break;
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      break;
    default:
      jj_la1[59] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return getToken(0);}
    throw new Error("Missing return statement in function");
  }

  final public Token AblName() throws ParseException {
    Token t;
    t = jj_consume_token(IDENTIFIER);
        {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public void WMEDeclaration() throws ParseException {
 /*@bgen(jjtree) WMEDecl */
    ASTWMEDecl jjtn000 = new ASTWMEDecl(JJTWMEDECL);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);Token t;
    try {
      jj_consume_token(WME);
      t = AblName();
        jjtn000.wmeClassName = t.image;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXTENDS:
        jj_consume_token(EXTENDS);
        t = AblName();
                                jjtn000.wmeExtendsClass = t.image;
        break;
      default:
        jj_la1[60] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
      label_28:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FLOAT:
        case INT:
        case LONG:
        case SHORT:
        case IDENTIFIER:
          ;
          break;
        default:
          jj_la1[61] = jj_gen;
          break label_28;
        }
        AblVariableDeclaration();
        jj_consume_token(SEMICOLON);
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void TeamNeededForSuccessDefaultDeclaration(ASTBehaviorUnit behUnit) throws ParseException {
   boolean teamNeededForSuccess;
    jj_consume_token(JOINT_GOAL_SUCCESS_NEGOTIATION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEAM_NEEDED_FOR_SUCCESS:
      jj_consume_token(TEAM_NEEDED_FOR_SUCCESS);
                                 teamNeededForSuccess = true;
      break;
    case ONE_NEEDED_FOR_SUCCESS:
      jj_consume_token(ONE_NEEDED_FOR_SUCCESS);
                                                                                             teamNeededForSuccess = false;
      break;
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
     if (!behUnit.setTeamNeededForSuccess(teamNeededForSuccess))
        {if (true) throw new ParseException("Multiple joint_goal_success_negotiation declarations");}
  }

  final public void DecisionCycleSMCallDeclaration(ASTBehaviorUnit behUnit) throws ParseException {
    ASTJavaName n;
    jj_consume_token(DECISION_CYCLE_SM_CALL);
    n = Name();
                 if (behUnit.decisionCycleSMCallNode == null)
                    behUnit.decisionCycleSMCallNode = n;
                 else
                    {if (true) throw new ParseException("Multiple decision cycle SM call declarations");}
    jj_consume_token(SEMICOLON);
  }

/******************************************************************************************
 * Java grammar begins here                                                               *
 * Java grammar embedded in ABL grammar for code conditional expressions and code actions *
 *****************************************************************************************/
  final public String ImportDeclaration() throws ParseException {
 /*@bgen(jjtree) ImportDeclaration */
  ASTImportDeclaration jjtn000 = new ASTImportDeclaration(JJTIMPORTDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(IMPORT);
      Name();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        jj_consume_token(DOT);
        jj_consume_token(STAR);
        break;
      default:
        jj_la1[63] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtreeCloseNodeScope(jjtn000);
    {if (true) return jjtn000.dumpTokens(1, jjtn000.numberOfTokens() - 1);}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * Declaration syntax follows.
 */
  final public void UnmodifiedClassDeclaration() throws ParseException {
    jj_consume_token(CLASS);
    jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTENDS:
      jj_consume_token(EXTENDS);
      Name();
      break;
    default:
      jj_la1[64] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IMPLEMENTS:
      jj_consume_token(IMPLEMENTS);
      NameList();
      break;
    default:
      jj_la1[65] = jj_gen;
      ;
    }
    ClassBody();
  }

  final public void ClassBody() throws ParseException {
    jj_consume_token(LBRACE);
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case DOUBLE:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOID:
      case VOLATILE:
      case IDENTIFIER:
      case LBRACE:
        ;
        break;
      default:
        jj_la1[66] = jj_gen;
        break label_29;
      }
      ClassBodyDeclaration();
    }
    jj_consume_token(RBRACE);
  }

  final public void NestedClassDeclaration() throws ParseException {
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case FINAL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
        ;
        break;
      default:
        jj_la1[67] = jj_gen;
        break label_30;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STATIC:
        jj_consume_token(STATIC);
        break;
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
        break;
      case FINAL:
        jj_consume_token(FINAL);
        break;
      case PUBLIC:
        jj_consume_token(PUBLIC);
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
        break;
      default:
        jj_la1[68] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    UnmodifiedClassDeclaration();
  }

  final public void ClassBodyDeclaration() throws ParseException {
    if (jj_2_12(2)) {
      Initializer();
    } else if (jj_2_13(2147483647)) {
      NestedClassDeclaration();
    } else if (jj_2_14(2147483647)) {
      NestedInterfaceDeclaration();
    } else if (jj_2_15(2147483647)) {
      ConstructorDeclaration();
    } else if (jj_2_16(2147483647)) {
      MethodDeclaration();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FINAL:
      case FLOAT:
      case INT:
      case LONG:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case TRANSIENT:
      case VOLATILE:
      case IDENTIFIER:
        FieldDeclaration();
        break;
      default:
        jj_la1[69] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

// This production is to determine lookahead only.
  final public void MethodDeclarationLookahead() throws ParseException {
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case FINAL:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case SYNCHRONIZED:
        ;
        break;
      default:
        jj_la1[70] = jj_gen;
        break label_31;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
        jj_consume_token(PUBLIC);
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
        break;
      case STATIC:
        jj_consume_token(STATIC);
        break;
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
        break;
      case FINAL:
        jj_consume_token(FINAL);
        break;
      case NATIVE:
        jj_consume_token(NATIVE);
        break;
      case SYNCHRONIZED:
        jj_consume_token(SYNCHRONIZED);
        break;
      default:
        jj_la1[71] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    ResultType();
    jj_consume_token(IDENTIFIER);
    jj_consume_token(LPAREN);
  }

  final public void NestedInterfaceDeclaration() throws ParseException {
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case FINAL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
        ;
        break;
      default:
        jj_la1[72] = jj_gen;
        break label_32;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STATIC:
        jj_consume_token(STATIC);
        break;
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
        break;
      case FINAL:
        jj_consume_token(FINAL);
        break;
      case PUBLIC:
        jj_consume_token(PUBLIC);
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
        break;
      default:
        jj_la1[73] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    UnmodifiedInterfaceDeclaration();
  }

  final public void UnmodifiedInterfaceDeclaration() throws ParseException {
    jj_consume_token(INTERFACE);
    jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTENDS:
      jj_consume_token(EXTENDS);
      NameList();
      break;
    default:
      jj_la1[74] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case DOUBLE:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOID:
      case VOLATILE:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[75] = jj_gen;
        break label_33;
      }
      InterfaceMemberDeclaration();
    }
    jj_consume_token(RBRACE);
  }

  final public void InterfaceMemberDeclaration() throws ParseException {
    if (jj_2_17(2147483647)) {
      NestedClassDeclaration();
    } else if (jj_2_18(2147483647)) {
      NestedInterfaceDeclaration();
    } else if (jj_2_19(2147483647)) {
      MethodDeclaration();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FINAL:
      case FLOAT:
      case INT:
      case LONG:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case TRANSIENT:
      case VOLATILE:
      case IDENTIFIER:
        FieldDeclaration();
        break;
      default:
        jj_la1[76] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void FieldDeclaration() throws ParseException {
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FINAL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case TRANSIENT:
      case VOLATILE:
        ;
        break;
      default:
        jj_la1[77] = jj_gen;
        break label_34;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
        jj_consume_token(PUBLIC);
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
        break;
      case STATIC:
        jj_consume_token(STATIC);
        break;
      case FINAL:
        jj_consume_token(FINAL);
        break;
      case TRANSIENT:
        jj_consume_token(TRANSIENT);
        break;
      case VOLATILE:
        jj_consume_token(VOLATILE);
        break;
      default:
        jj_la1[78] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    Type();
    VariableDeclarator();
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[79] = jj_gen;
        break label_35;
      }
      jj_consume_token(COMMA);
      VariableDeclarator();
    }
    jj_consume_token(SEMICOLON);
  }

  final public void VariableDeclarator() throws ParseException {
    VariableDeclaratorId();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGN:
      jj_consume_token(ASSIGN);
      VariableInitializer();
      break;
    default:
      jj_la1[80] = jj_gen;
      ;
    }
  }

  final public void VariableDeclaratorId() throws ParseException {
 /*@bgen(jjtree) VariableDeclaratorID */
  ASTVariableDeclaratorID jjtn000 = new ASTVariableDeclaratorID(JJTVARIABLEDECLARATORID);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(IDENTIFIER);
      label_36:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
          ;
          break;
        default:
          jj_la1[81] = jj_gen;
          break label_36;
        }
        jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
      }
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void VariableInitializer() throws ParseException {
 /*@bgen(jjtree) VariableInitializer */
  ASTVariableInitializer jjtn000 = new ASTVariableInitializer(JJTVARIABLEINITIALIZER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        ArrayInitializer();
        break;
      default:
        jj_la1[82] = jj_gen;
        if (jj_2_20(1)) {
          Expression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void ArrayInitializer() throws ParseException {
    jj_consume_token(LBRACE);
    if (jj_2_22(1)) {
      VariableInitializer();
      label_37:
      while (true) {
        if (jj_2_21(2)) {
          ;
        } else {
          break label_37;
        }
        jj_consume_token(COMMA);
        VariableInitializer();
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[83] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
  }

  final public void MethodDeclaration() throws ParseException {
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case FINAL:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case SYNCHRONIZED:
        ;
        break;
      default:
        jj_la1[84] = jj_gen;
        break label_38;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
        jj_consume_token(PUBLIC);
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
        break;
      case STATIC:
        jj_consume_token(STATIC);
        break;
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
        break;
      case FINAL:
        jj_consume_token(FINAL);
        break;
      case NATIVE:
        jj_consume_token(NATIVE);
        break;
      case SYNCHRONIZED:
        jj_consume_token(SYNCHRONIZED);
        break;
      default:
        jj_la1[85] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    ResultType();
    MethodDeclarator();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case THROWS:
      jj_consume_token(THROWS);
      NameList();
      break;
    default:
      jj_la1[86] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      Block();
      break;
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[87] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void MethodDeclarator() throws ParseException {
    jj_consume_token(IDENTIFIER);
    FormalParameters();
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        ;
        break;
      default:
        jj_la1[88] = jj_gen;
        break label_39;
      }
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
    }
  }

  final public void FormalParameters() throws ParseException {
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FINAL:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case IDENTIFIER:
      FormalParameter();
      label_40:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[89] = jj_gen;
          break label_40;
        }
        jj_consume_token(COMMA);
        FormalParameter();
      }
      break;
    default:
      jj_la1[90] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
  }

  final public void FormalParameter() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FINAL:
      jj_consume_token(FINAL);
      break;
    default:
      jj_la1[91] = jj_gen;
      ;
    }
    Type();
    VariableDeclaratorId();
  }

  final public void ConstructorDeclaration() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
        jj_consume_token(PUBLIC);
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
        break;
      default:
        jj_la1[92] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[93] = jj_gen;
      ;
    }
    jj_consume_token(IDENTIFIER);
    FormalParameters();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case THROWS:
      jj_consume_token(THROWS);
      NameList();
      break;
    default:
      jj_la1[94] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    if (jj_2_23(2147483647)) {
      ExplicitConstructorInvocation();
    } else {
      ;
    }
    label_41:
    while (true) {
      if (jj_2_24(1)) {
        ;
      } else {
        break label_41;
      }
      BlockStatement();
    }
    jj_consume_token(RBRACE);
  }

  final public void ExplicitConstructorInvocation() throws ParseException {
    if (jj_2_26(2147483647)) {
      jj_consume_token(THIS);
      Arguments();
      jj_consume_token(SEMICOLON);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case DOUBLE_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
        if (jj_2_25(2)) {
          PrimaryExpression();
          jj_consume_token(DOT);
        } else {
          ;
        }
        jj_consume_token(SUPER);
        Arguments();
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[95] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void Initializer() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STATIC:
      jj_consume_token(STATIC);
      break;
    default:
      jj_la1[96] = jj_gen;
      ;
    }
    Block();
  }

/*
 * Type, name and expression syntax follows.
 */
  final public void Type() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
      PrimitiveType();
      break;
    case IDENTIFIER:
      Name();
      break;
    default:
      jj_la1[97] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        ;
        break;
      default:
        jj_la1[98] = jj_gen;
        break label_42;
      }
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
    }
  }

  final public Token PrimitiveType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
      jj_consume_token(BOOLEAN);
      break;
    case CHAR:
      jj_consume_token(CHAR);
      break;
    case BYTE:
      jj_consume_token(BYTE);
      break;
    case SHORT:
      jj_consume_token(SHORT);
      break;
    case INT:
      jj_consume_token(INT);
      break;
    case LONG:
      jj_consume_token(LONG);
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
      break;
    default:
      jj_la1[99] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return getToken(0);}
    throw new Error("Missing return statement in function");
  }

  final public void ResultType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOID:
      jj_consume_token(VOID);
      break;
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case IDENTIFIER:
      Type();
      break;
    default:
      jj_la1[100] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public ASTJavaName Name() throws ParseException {
 /*@bgen(jjtree) JavaName */
  ASTJavaName jjtn000 = new ASTJavaName(JJTJAVANAME);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(IDENTIFIER);
      label_43:
      while (true) {
        if (jj_2_27(2)) {
          ;
        } else {
          break label_43;
        }
        jj_consume_token(DOT);
        jj_consume_token(IDENTIFIER);
      }
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     jjtreeCloseNodeScope(jjtn000);
     {if (true) return jjtn000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
    throw new Error("Missing return statement in function");
  }

  final public void NameList() throws ParseException {
    Name();
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[101] = jj_gen;
        break label_44;
      }
      jj_consume_token(COMMA);
      Name();
    }
  }

/*
 * Expression syntax follows.
 */
  final public void Expression() throws ParseException {
    ConditionalExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGN:
    case PLUSASSIGN:
    case MINUSASSIGN:
    case STARASSIGN:
    case SLASHASSIGN:
    case ANDASSIGN:
    case ORASSIGN:
    case XORASSIGN:
    case REMASSIGN:
    case LSHIFTASSIGN:
    case RSIGNEDSHIFTASSIGN:
    case RUNSIGNEDSHIFTASSIGN:
      AssignmentOperator();
      Expression();
      break;
    default:
      jj_la1[102] = jj_gen;
      ;
    }
  }

  final public void AssignmentOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGN:
      jj_consume_token(ASSIGN);
      break;
    case STARASSIGN:
      jj_consume_token(STARASSIGN);
      break;
    case SLASHASSIGN:
      jj_consume_token(SLASHASSIGN);
      break;
    case REMASSIGN:
      jj_consume_token(REMASSIGN);
      break;
    case PLUSASSIGN:
      jj_consume_token(PLUSASSIGN);
      break;
    case MINUSASSIGN:
      jj_consume_token(MINUSASSIGN);
      break;
    case LSHIFTASSIGN:
      jj_consume_token(LSHIFTASSIGN);
      break;
    case RSIGNEDSHIFTASSIGN:
      jj_consume_token(RSIGNEDSHIFTASSIGN);
      break;
    case RUNSIGNEDSHIFTASSIGN:
      jj_consume_token(RUNSIGNEDSHIFTASSIGN);
      break;
    case ANDASSIGN:
      jj_consume_token(ANDASSIGN);
      break;
    case XORASSIGN:
      jj_consume_token(XORASSIGN);
      break;
    case ORASSIGN:
      jj_consume_token(ORASSIGN);
      break;
    default:
      jj_la1[103] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ConditionalExpression() throws ParseException {
 /*@bgen(jjtree) ConditionalExpression */
  ASTConditionalExpression jjtn000 = new ASTConditionalExpression(JJTCONDITIONALEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      ConditionalOrExpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOOK:
        jj_consume_token(HOOK);
        Expression();
        jj_consume_token(COLON);
        ConditionalExpression();
        break;
      default:
        jj_la1[104] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void ConditionalOrExpression() throws ParseException {
    ConditionalAndExpression();
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SC_OR:
        ;
        break;
      default:
        jj_la1[105] = jj_gen;
        break label_45;
      }
      jj_consume_token(SC_OR);
      ConditionalAndExpression();
    }
  }

  final public void ConditionalAndExpression() throws ParseException {
    InclusiveOrExpression();
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SC_AND:
        ;
        break;
      default:
        jj_la1[106] = jj_gen;
        break label_46;
      }
      jj_consume_token(SC_AND);
      InclusiveOrExpression();
    }
  }

  final public void InclusiveOrExpression() throws ParseException {
    ExclusiveOrExpression();
    label_47:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_OR:
        ;
        break;
      default:
        jj_la1[107] = jj_gen;
        break label_47;
      }
      jj_consume_token(BIT_OR);
      ExclusiveOrExpression();
    }
  }

  final public void ExclusiveOrExpression() throws ParseException {
    AndExpression();
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XOR:
        ;
        break;
      default:
        jj_la1[108] = jj_gen;
        break label_48;
      }
      jj_consume_token(XOR);
      AndExpression();
    }
  }

  final public void AndExpression() throws ParseException {
    EqualityExpression();
    label_49:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_AND:
        ;
        break;
      default:
        jj_la1[109] = jj_gen;
        break label_49;
      }
      jj_consume_token(BIT_AND);
      EqualityExpression();
    }
  }

  final public void EqualityExpression() throws ParseException {
    InstanceOfExpression();
    label_50:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
      case NE:
        ;
        break;
      default:
        jj_la1[110] = jj_gen;
        break label_50;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        jj_consume_token(EQ);
        break;
      case NE:
        jj_consume_token(NE);
        break;
      default:
        jj_la1[111] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      InstanceOfExpression();
    }
  }

  final public void InstanceOfExpression() throws ParseException {
    RelationalExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSTANCEOF:
      jj_consume_token(INSTANCEOF);
      Type();
      break;
    default:
      jj_la1[112] = jj_gen;
      ;
    }
  }

  final public void RelationalExpression() throws ParseException {
    ShiftExpression();
    label_51:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GT:
      case LT:
      case LE:
      case GE:
        ;
        break;
      default:
        jj_la1[113] = jj_gen;
        break label_51;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
        jj_consume_token(LT);
        break;
      case GT:
        jj_consume_token(GT);
        break;
      case LE:
        jj_consume_token(LE);
        break;
      case GE:
        jj_consume_token(GE);
        break;
      default:
        jj_la1[114] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      ShiftExpression();
    }
  }

  final public void ShiftExpression() throws ParseException {
    AdditiveExpression();
    label_52:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSHIFT:
      case RSIGNEDSHIFT:
      case RUNSIGNEDSHIFT:
        ;
        break;
      default:
        jj_la1[115] = jj_gen;
        break label_52;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSHIFT:
        jj_consume_token(LSHIFT);
        break;
      case RSIGNEDSHIFT:
        jj_consume_token(RSIGNEDSHIFT);
        break;
      case RUNSIGNEDSHIFT:
        jj_consume_token(RUNSIGNEDSHIFT);
        break;
      default:
        jj_la1[116] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      AdditiveExpression();
    }
  }

  final public void AdditiveExpression() throws ParseException {
    MultiplicativeExpression();
    label_53:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[117] = jj_gen;
        break label_53;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        break;
      default:
        jj_la1[118] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      MultiplicativeExpression();
    }
  }

  final public void MultiplicativeExpression() throws ParseException {
    UnaryExpression();
    label_54:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
      case SLASH:
      case REM:
        ;
        break;
      default:
        jj_la1[119] = jj_gen;
        break label_54;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
        break;
      case SLASH:
        jj_consume_token(SLASH);
        break;
      case REM:
        jj_consume_token(REM);
        break;
      default:
        jj_la1[120] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      UnaryExpression();
    }
  }

  final public void UnaryExpression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        break;
      default:
        jj_la1[121] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      UnaryExpression();
      break;
    case INCR:
      PreIncrementExpression();
      break;
    case DECR:
      PreDecrementExpression();
      break;
    default:
      jj_la1[122] = jj_gen;
      if (jj_2_28(1)) {
        UnaryExpressionNotPlusMinus();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void PreIncrementExpression() throws ParseException {
    jj_consume_token(INCR);
    PrimaryExpression();
  }

  final public void PreDecrementExpression() throws ParseException {
    jj_consume_token(DECR);
    PrimaryExpression();
  }

  final public void UnaryExpressionNotPlusMinus() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BANG:
    case TILDE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TILDE:
        jj_consume_token(TILDE);
        break;
      case BANG:
        jj_consume_token(BANG);
        break;
      default:
        jj_la1[123] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      UnaryExpression();
      break;
    default:
      jj_la1[124] = jj_gen;
      if (isTypeCast()) {
        CastExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case SUPER:
        case THIS:
        case TRUE:
        case VOID:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case DOUBLE_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
          PostfixExpression();
          break;
        default:
          jj_la1[125] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void PostfixExpression() throws ParseException {
    PrimaryExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCR:
    case DECR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INCR:
        jj_consume_token(INCR);
        break;
      case DECR:
        jj_consume_token(DECR);
        break;
      default:
        jj_la1[126] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[127] = jj_gen;
      ;
    }
  }

  final public void CastExpression() throws ParseException {
    if (jj_2_29(2147483647)) {
      jj_consume_token(LPAREN);
      Type();
      jj_consume_token(RPAREN);
      UnaryExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        Type();
        jj_consume_token(RPAREN);
        UnaryExpressionNotPlusMinus();
        break;
      default:
        jj_la1[128] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void PrimaryExpression() throws ParseException {
    PrimaryPrefix();
    label_55:
    while (true) {
      if (jj_2_30(2)) {
        ;
      } else {
        break label_55;
      }
      PrimarySuffix();
    }
  }

  final public void PrimaryPrefix() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case DOUBLE_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
      Literal();
      break;
    case THIS:
      jj_consume_token(THIS);
      break;
    case SUPER:
      jj_consume_token(SUPER);
      jj_consume_token(DOT);
      jj_consume_token(IDENTIFIER);
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      break;
    case NEW:
      AllocationExpression();
      break;
    default:
      jj_la1[129] = jj_gen;
      if (jj_2_31(2147483647)) {
        ResultType();
        jj_consume_token(DOT);
        jj_consume_token(CLASS);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENTIFIER:
          Name();
          break;
        default:
          jj_la1[130] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void PrimarySuffix() throws ParseException {
    if (jj_2_32(2)) {
      jj_consume_token(DOT);
      jj_consume_token(THIS);
    } else if (jj_2_33(2)) {
      jj_consume_token(DOT);
      AllocationExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        jj_consume_token(LBRACKET);
        Expression();
        jj_consume_token(RBRACKET);
        break;
      case DOT:
        jj_consume_token(DOT);
        jj_consume_token(IDENTIFIER);
        break;
      case LPAREN:
        Arguments();
        break;
      default:
        jj_la1[131] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void Literal() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case FLOATING_POINT_LITERAL:
      jj_consume_token(FLOATING_POINT_LITERAL);
      break;
    case CHARACTER_LITERAL:
      jj_consume_token(CHARACTER_LITERAL);
      break;
    case DOUBLE_LITERAL:
      jj_consume_token(DOUBLE_LITERAL);
      break;
    case STRING_LITERAL:
      jj_consume_token(STRING_LITERAL);
      break;
    case FALSE:
    case TRUE:
      BooleanLiteral();
      break;
    case NULL:
      NullLiteral();
      break;
    default:
      jj_la1[132] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Token BooleanLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
      break;
    case FALSE:
      jj_consume_token(FALSE);
      break;
    default:
      jj_la1[133] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return getToken(0);}
    throw new Error("Missing return statement in function");
  }

  final public void NullLiteral() throws ParseException {
    jj_consume_token(NULL);
  }

  final public void Arguments() throws ParseException {
    jj_consume_token(LPAREN);
    if (jj_2_34(1)) {
      ArgumentList();
    } else {
      ;
    }
    jj_consume_token(RPAREN);
  }

  final public void ArgumentList() throws ParseException {
    Expression();
    label_56:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[134] = jj_gen;
        break label_56;
      }
      jj_consume_token(COMMA);
      Expression();
    }
  }

  final public void AllocationExpression() throws ParseException {
    if (jj_2_35(2)) {
      jj_consume_token(NEW);
      PrimitiveType();
      ArrayDimsAndInits();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEW:
        jj_consume_token(NEW);
        Name();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
          ArrayDimsAndInits();
          break;
        case LPAREN:
          Arguments();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE:
            ClassBody();
            break;
          default:
            jj_la1[135] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[136] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[137] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 * The third LOOKAHEAD specification below is to parse to PrimarySuffix
 * if there is an expression between the "[...]".
 */
  final public void ArrayDimsAndInits() throws ParseException {
    if (jj_2_38(2)) {
      label_57:
      while (true) {
        jj_consume_token(LBRACKET);
        Expression();
        jj_consume_token(RBRACKET);
        if (jj_2_36(2)) {
          ;
        } else {
          break label_57;
        }
      }
      label_58:
      while (true) {
        if (jj_2_37(2)) {
          ;
        } else {
          break label_58;
        }
        jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        label_59:
        while (true) {
          jj_consume_token(LBRACKET);
          jj_consume_token(RBRACKET);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACKET:
            ;
            break;
          default:
            jj_la1[138] = jj_gen;
            break label_59;
          }
        }
        ArrayInitializer();
        break;
      default:
        jj_la1[139] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 * Statement syntax follows.
 */
  final public void Statement() throws ParseException {
 /*@bgen(jjtree) JavaStatement */
  ASTJavaStatement jjtn000 = new ASTJavaStatement(JJTJAVASTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      if (getToken(1).kind == IDENTIFIER && getToken(2).kind == COLON) {
        LabeledStatement();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          Block();
          break;
        case SEMICOLON:
          EmptyStatement();
          break;
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case SUPER:
        case THIS:
        case TRUE:
        case VOID:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case DOUBLE_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case INCR:
        case DECR:
          StatementExpression();
          jj_consume_token(SEMICOLON);
          break;
        case SWITCH:
          SwitchStatement();
          break;
        case IF:
          IfStatement();
          break;
        case WHILE:
          WhileStatement();
          break;
        case DO:
          DoStatement();
          break;
        case FOR:
          ForStatement();
          break;
        case BREAK:
          BreakStatement();
          break;
        case CONTINUE:
          ContinueStatement();
          break;
        case RETURN:
          ReturnStatement();
          break;
        case THROW:
          ThrowStatement();
          break;
        case SYNCHRONIZED:
          SynchronizedStatement();
          break;
        case TRY:
          TryStatement();
          break;
        case ASSERT:
          AssertStatement();
          break;
        default:
          jj_la1[140] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void LabeledStatement() throws ParseException {
    jj_consume_token(IDENTIFIER);
    jj_consume_token(COLON);
    Statement();
  }

/* For ABL, blocks consist of statements rather than blockstatements since we don't allow class declarations in mental acts. */
  final public void Block() throws ParseException {
    jj_consume_token(LBRACE);
    label_60:
    while (true) {
      if (jj_2_39(1)) {
        ;
      } else {
        break label_60;
      }
      Statement();
    }
    jj_consume_token(RBRACE);
  }

/* void Block() :
{}
{
  "{" ( BlockStatement() )* "}"
} */
  final public void BlockStatement() throws ParseException {
    if (jj_2_40(2147483647)) {
      LocalVariableDeclaration();
      jj_consume_token(SEMICOLON);
    } else if (jj_2_41(1)) {
      Statement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CLASS:
        UnmodifiedClassDeclaration();
        break;
      case INTERFACE:
        UnmodifiedInterfaceDeclaration();
        break;
      default:
        jj_la1[141] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void LocalVariableDeclaration() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FINAL:
      jj_consume_token(FINAL);
      break;
    default:
      jj_la1[142] = jj_gen;
      ;
    }
    Type();
    VariableDeclarator();
    label_61:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[143] = jj_gen;
        break label_61;
      }
      jj_consume_token(COMMA);
      VariableDeclarator();
    }
  }

  final public void EmptyStatement() throws ParseException {
    jj_consume_token(SEMICOLON);
  }

  final public void StatementExpression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCR:
      PreIncrementExpression();
      break;
    case DECR:
      PreDecrementExpression();
      break;
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case DOUBLE_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
      PrimaryExpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGN:
      case INCR:
      case DECR:
      case PLUSASSIGN:
      case MINUSASSIGN:
      case STARASSIGN:
      case SLASHASSIGN:
      case ANDASSIGN:
      case ORASSIGN:
      case XORASSIGN:
      case REMASSIGN:
      case LSHIFTASSIGN:
      case RSIGNEDSHIFTASSIGN:
      case RUNSIGNEDSHIFTASSIGN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INCR:
          jj_consume_token(INCR);
          break;
        case DECR:
          jj_consume_token(DECR);
          break;
        case ASSIGN:
        case PLUSASSIGN:
        case MINUSASSIGN:
        case STARASSIGN:
        case SLASHASSIGN:
        case ANDASSIGN:
        case ORASSIGN:
        case XORASSIGN:
        case REMASSIGN:
        case LSHIFTASSIGN:
        case RSIGNEDSHIFTASSIGN:
        case RUNSIGNEDSHIFTASSIGN:
          AssignmentOperator();
          Expression();
          break;
        default:
          jj_la1[144] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[145] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[146] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void SwitchStatement() throws ParseException {
    jj_consume_token(SWITCH);
    jj_consume_token(LPAREN);
    Expression();
    jj_consume_token(RPAREN);
    jj_consume_token(LBRACE);
    label_62:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
      case _DEFAULT:
        ;
        break;
      default:
        jj_la1[147] = jj_gen;
        break label_62;
      }
      SwitchLabel();
      label_63:
      while (true) {
        if (jj_2_42(1)) {
          ;
        } else {
          break label_63;
        }
        BlockStatement();
      }
    }
    jj_consume_token(RBRACE);
  }

  final public void SwitchLabel() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CASE:
      jj_consume_token(CASE);
      Expression();
      jj_consume_token(COLON);
      break;
    case _DEFAULT:
      jj_consume_token(_DEFAULT);
      jj_consume_token(COLON);
      break;
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void IfStatement() throws ParseException {
    jj_consume_token(IF);
    jj_consume_token(LPAREN);
    Expression();
    jj_consume_token(RPAREN);
    Statement();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      Statement();
      break;
    default:
      jj_la1[149] = jj_gen;
      ;
    }
  }

  final public void WhileStatement() throws ParseException {
    jj_consume_token(WHILE);
    jj_consume_token(LPAREN);
    Expression();
    jj_consume_token(RPAREN);
    Statement();
  }

  final public void DoStatement() throws ParseException {
    jj_consume_token(DO);
    Statement();
    jj_consume_token(WHILE);
    jj_consume_token(LPAREN);
    Expression();
    jj_consume_token(RPAREN);
    jj_consume_token(SEMICOLON);
  }

  final public void ForStatement() throws ParseException {
    jj_consume_token(FOR);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FINAL:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case DOUBLE_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case INCR:
    case DECR:
      ForInit();
      break;
    default:
      jj_la1[150] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    if (jj_2_43(1)) {
      Expression();
    } else {
      ;
    }
    jj_consume_token(SEMICOLON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case DOUBLE_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case INCR:
    case DECR:
      ForUpdate();
      break;
    default:
      jj_la1[151] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    Statement();
  }

  final public void ForInit() throws ParseException {
    if (jj_2_44(2147483647)) {
      LocalVariableDeclaration();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case DOUBLE_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case INCR:
      case DECR:
        StatementExpressionList();
        break;
      default:
        jj_la1[152] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void StatementExpressionList() throws ParseException {
    StatementExpression();
    label_64:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[153] = jj_gen;
        break label_64;
      }
      jj_consume_token(COMMA);
      StatementExpression();
    }
  }

  final public void ForUpdate() throws ParseException {
    StatementExpressionList();
  }

  final public void BreakStatement() throws ParseException {
    jj_consume_token(BREAK);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      break;
    default:
      jj_la1[154] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
  }

  final public void ContinueStatement() throws ParseException {
    jj_consume_token(CONTINUE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      break;
    default:
      jj_la1[155] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
  }

  final public void ReturnStatement() throws ParseException {
    jj_consume_token(RETURN);
    if (jj_2_45(1)) {
      Expression();
    } else {
      ;
    }
    jj_consume_token(SEMICOLON);
  }

  final public void ThrowStatement() throws ParseException {
    jj_consume_token(THROW);
    Expression();
    jj_consume_token(SEMICOLON);
  }

  final public void SynchronizedStatement() throws ParseException {
    jj_consume_token(SYNCHRONIZED);
    jj_consume_token(LPAREN);
    Expression();
    jj_consume_token(RPAREN);
    Block();
  }

  final public void TryStatement() throws ParseException {
    jj_consume_token(TRY);
    Block();
    label_65:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CATCH:
        ;
        break;
      default:
        jj_la1[156] = jj_gen;
        break label_65;
      }
      jj_consume_token(CATCH);
      jj_consume_token(LPAREN);
      FormalParameter();
      jj_consume_token(RPAREN);
      Block();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FINALLY:
      jj_consume_token(FINALLY);
      Block();
      break;
    default:
      jj_la1[157] = jj_gen;
      ;
    }
  }

// fixme: eventually would like assert statements to only accept boolean-valued expressions. 
  final public void AssertStatement() throws ParseException {
    jj_consume_token(ASSERT);
    Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      jj_consume_token(COLON);
      Expression();
      break;
    default:
      jj_la1[158] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  final private boolean jj_3R_153() {
    if (jj_scan_token(ASSERT)) return true;
    if (jj_3R_82()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_273()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_272() {
    if (jj_scan_token(FINALLY)) return true;
    if (jj_3R_118()) return true;
    return false;
  }

  final private boolean jj_3R_271() {
    if (jj_scan_token(CATCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_258()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_118()) return true;
    return false;
  }

  final private boolean jj_3R_152() {
    if (jj_scan_token(TRY)) return true;
    if (jj_3R_118()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_271()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_272()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_270() {
    if (jj_3R_278()) return true;
    return false;
  }

  final private boolean jj_3R_151() {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_118()) return true;
    return false;
  }

  final private boolean jj_3R_138() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_150() {
    if (jj_scan_token(THROW)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_285() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_141()) return true;
    return false;
  }

  final private boolean jj_3R_149() {
    if (jj_scan_token(RETURN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_45()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_3R_70()) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3R_148() {
    if (jj_scan_token(CONTINUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(129)) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_147() {
    if (jj_scan_token(BREAK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(129)) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_268() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3R_278() {
    if (jj_3R_284()) return true;
    return false;
  }

  final private boolean jj_3_44() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(30)) jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_284() {
    if (jj_3R_141()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_285()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_269() {
    if (jj_3R_277()) return true;
    return false;
  }

  final private boolean jj_3R_283() {
    if (jj_3R_284()) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_70()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_282() {
    if (jj_3R_156()) return true;
    return false;
  }

  final private boolean jj_3R_277() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_282()) {
    jj_scanpos = xsp;
    if (jj_3R_283()) return true;
    }
    return false;
  }

  final private boolean jj_3R_146() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_269()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3_43()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3R_270()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3_9() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3_11()) return true;
    }
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_3R_99()) return true;
    return false;
  }

  final private boolean jj_3R_145() {
    if (jj_scan_token(DO)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_144() {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3R_143() {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_71()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_268()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_281() {
    if (jj_scan_token(_DEFAULT)) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  final private boolean jj_3R_72() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) return true;
    }
    return false;
  }

  final private boolean jj_3R_280() {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  final private boolean jj_3R_276() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_280()) {
    jj_scanpos = xsp;
    if (jj_3R_281()) return true;
    }
    return false;
  }

  final private boolean jj_3R_266() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_245()) return true;
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_3R_85()) return true;
    return false;
  }

  final private boolean jj_3R_267() {
    if (jj_3R_276()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_42()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_142() {
    if (jj_scan_token(SWITCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_267()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_279() {
    if (jj_3R_192()) return true;
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_275() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(154)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_3R_279()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_173() {
    if (jj_3R_86()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_275()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_172() {
    if (jj_3R_184()) return true;
    return false;
  }

  final private boolean jj_3R_141() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_171() {
    if (jj_3R_183()) return true;
    return false;
  }

  final private boolean jj_3R_156() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(30)) jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    if (jj_3R_245()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_266()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_40() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(30)) jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_126() {
    if (jj_3R_158()) return true;
    return false;
  }

  final private boolean jj_3R_125() {
    if (jj_3R_157()) return true;
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3R_124() {
    if (jj_3R_156()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) {
    jj_scanpos = xsp;
    if (jj_3R_126()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_scan_token(PERSISTENT)) return true;
    if (jj_3R_72()) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(REGISTER)) return true;
    if (jj_scan_token(WME)) return true;
    return false;
  }

  final private boolean jj_3_39() {
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3R_118() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_39()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_140() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3R_117() {
    if (jj_3R_153()) return true;
    return false;
  }

  final private boolean jj_3R_116() {
    if (jj_3R_152()) return true;
    return false;
  }

  final private boolean jj_3R_115() {
    if (jj_3R_151()) return true;
    return false;
  }

  final private boolean jj_3R_114() {
    if (jj_3R_150()) return true;
    return false;
  }

  final private boolean jj_3R_113() {
    if (jj_3R_149()) return true;
    return false;
  }

  final private boolean jj_3R_112() {
    if (jj_3R_148()) return true;
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_111() {
    if (jj_3R_147()) return true;
    return false;
  }

  final private boolean jj_3R_110() {
    if (jj_3R_146()) return true;
    return false;
  }

  final private boolean jj_3R_109() {
    if (jj_3R_145()) return true;
    return false;
  }

  final private boolean jj_3R_108() {
    if (jj_3R_144()) return true;
    return false;
  }

  final private boolean jj_3R_107() {
    if (jj_3R_143()) return true;
    return false;
  }

  final private boolean jj_3R_106() {
    if (jj_3R_142()) return true;
    return false;
  }

  final private boolean jj_3R_105() {
    if (jj_3R_141()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_104() {
    if (jj_3R_118()) return true;
    return false;
  }

  final private boolean jj_3R_103() {
    if (jj_3R_140()) return true;
    return false;
  }

  final private boolean jj_3R_71() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == IDENTIFIER && getToken(2).kind == COLON;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_206() {
    if (jj_3R_210()) return true;
    return false;
  }

  final private boolean jj_3R_209() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_205() {
    Token xsp;
    if (jj_3R_209()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_209()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_155()) return true;
    return false;
  }

  final private boolean jj_3_38() {
    Token xsp;
    if (jj_3_36()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_36()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_37()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_200() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3R_205()) return true;
    }
    return false;
  }

  final private boolean jj_3R_202() {
    if (jj_3R_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_206()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_176() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_201() {
    if (jj_3R_200()) return true;
    return false;
  }

  final private boolean jj_3R_135() {
    if (jj_scan_token(NEW)) return true;
    if (jj_3R_78()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) return true;
    }
    return false;
  }

  final private boolean jj_3R_92() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_35()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) return true;
    }
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_scan_token(NEW)) return true;
    if (jj_3R_89()) return true;
    if (jj_3R_200()) return true;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_3R_82()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_176()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_3R_93()) return true;
    return false;
  }

  final private boolean jj_3R_87() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_34()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_191() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) return true;
    }
    return false;
  }

  final private boolean jj_3R_186() {
    if (jj_3R_191()) return true;
    return false;
  }

  final private boolean jj_3R_175() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_scan_token(125)) {
    jj_scanpos = xsp;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_3R_186()) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_133() {
    if (jj_3R_87()) return true;
    return false;
  }

  final private boolean jj_3R_132() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_131() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_92()) return true;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_3R_91()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  final private boolean jj_3R_90() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3_33()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_164() {
    if (jj_3R_78()) return true;
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_3R_90()) return true;
    return false;
  }

  final private boolean jj_3R_163() {
    if (jj_3R_91()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  final private boolean jj_3R_162() {
    if (jj_3R_92()) return true;
    return false;
  }

  final private boolean jj_3R_161() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_160() {
    if (jj_scan_token(SUPER)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_274() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(154)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) return true;
    }
    return false;
  }

  final private boolean jj_3R_159() {
    if (jj_3R_175()) return true;
    return false;
  }

  final private boolean jj_3R_127() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_89()) return true;
    return false;
  }

  final private boolean jj_3R_86() {
    if (jj_3R_127()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_30()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_178() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_70()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  final private boolean jj_3R_165() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) return true;
    }
    return false;
  }

  final private boolean jj_3R_177() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_70()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_218()) return true;
    return false;
  }

  final private boolean jj_3R_166() {
    if (jj_3R_86()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_274()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_130() {
    if (jj_3R_166()) return true;
    return false;
  }

  final private boolean jj_3R_129() {
    if (jj_3R_165()) return true;
    return false;
  }

  final private boolean jj_3R_128() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(144)) return true;
    }
    if (jj_3R_218()) return true;
    return false;
  }

  final private boolean jj_3R_88() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = isTypeCast();
    lookingAhead = false;
    if (!jj_semLA || jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_184() {
    if (jj_scan_token(DECR)) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  final private boolean jj_3R_233() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) return true;
    }
    if (jj_3R_215()) return true;
    return false;
  }

  final private boolean jj_3R_247() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(163)) return true;
    }
    }
    if (jj_3R_218()) return true;
    return false;
  }

  final private boolean jj_3R_183() {
    if (jj_scan_token(INCR)) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_3R_88()) return true;
    return false;
  }

  final private boolean jj_3R_224() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) return true;
    }
    }
    if (jj_3R_212()) return true;
    return false;
  }

  final private boolean jj_3R_227() {
    if (jj_3R_184()) return true;
    return false;
  }

  final private boolean jj_3R_226() {
    if (jj_3R_183()) return true;
    return false;
  }

  final private boolean jj_3R_218() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_225()) {
    jj_scanpos = xsp;
    if (jj_3R_226()) {
    jj_scanpos = xsp;
    if (jj_3R_227()) {
    jj_scanpos = xsp;
    if (jj_3_28()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_225() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) return true;
    }
    if (jj_3R_218()) return true;
    return false;
  }

  final private boolean jj_3R_217() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) return true;
    }
    }
    }
    if (jj_3R_208()) return true;
    return false;
  }

  final private boolean jj_3R_214() {
    if (jj_scan_token(INSTANCEOF)) return true;
    if (jj_3R_70()) return true;
    return false;
  }

  final private boolean jj_3R_215() {
    if (jj_3R_218()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_247()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_211() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) return true;
    }
    if (jj_3R_199()) return true;
    return false;
  }

  final private boolean jj_3R_212() {
    if (jj_3R_215()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_233()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_208() {
    if (jj_3R_212()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_224()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_207() {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_197()) return true;
    return false;
  }

  final private boolean jj_3R_204() {
    if (jj_3R_208()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_217()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_198() {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_190()) return true;
    return false;
  }

  final private boolean jj_3R_199() {
    if (jj_3R_204()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_214()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_203() {
    if (jj_scan_token(XOR)) return true;
    if (jj_3R_195()) return true;
    return false;
  }

  final private boolean jj_3R_196() {
    if (jj_scan_token(SC_AND)) return true;
    if (jj_3R_185()) return true;
    return false;
  }

  final private boolean jj_3R_197() {
    if (jj_3R_199()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_211()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_193() {
    if (jj_scan_token(SC_OR)) return true;
    if (jj_3R_174()) return true;
    return false;
  }

  final private boolean jj_3R_195() {
    if (jj_3R_197()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_207()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_188() {
    if (jj_scan_token(HOOK)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_120()) return true;
    return false;
  }

  final private boolean jj_3R_190() {
    if (jj_3R_195()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_203()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_185() {
    if (jj_3R_190()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_198()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_174() {
    if (jj_3R_185()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_196()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_154() {
    if (jj_3R_174()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_193()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_120() {
    if (jj_3R_154()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_188()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_192() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(141)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(175)) {
    jj_scanpos = xsp;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(177)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(173)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_187() {
    if (jj_3R_192()) return true;
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_3R_120()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_187()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_260() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_78()) return true;
    return false;
  }

  final private boolean jj_3R_253() {
    if (jj_3R_78()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_260()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_27()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_102() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_134() {
    if (jj_3R_70()) return true;
    return false;
  }

  final private boolean jj_3R_91() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_3R_134()) return true;
    }
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_70()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_101() {
    if (jj_3R_78()) return true;
    return false;
  }

  final private boolean jj_3_5() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3_7()) return true;
    }
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_3R_99()) return true;
    return false;
  }

  final private boolean jj_3R_89() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_100() {
    if (jj_3R_89()) return true;
    return false;
  }

  final private boolean jj_3R_238() {
    if (jj_scan_token(THROWS)) return true;
    if (jj_3R_253()) return true;
    return false;
  }

  final private boolean jj_3R_70() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_102()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_scan_token(THIS)) return true;
    if (jj_3R_87()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(51)) jj_scanpos = xsp;
    if (jj_3R_118()) return true;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_3R_84()) return true;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_3R_86()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_254() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_123() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_25()) jj_scanpos = xsp;
    if (jj_scan_token(SUPER)) return true;
    if (jj_3R_87()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_259() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_258()) return true;
    return false;
  }

  final private boolean jj_3R_122() {
    if (jj_scan_token(THIS)) return true;
    if (jj_3R_87()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_84() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) return true;
    }
    return false;
  }

  final private boolean jj_3R_242() {
    if (jj_scan_token(THROWS)) return true;
    if (jj_3R_253()) return true;
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_3R_85()) return true;
    return false;
  }

  final private boolean jj_3R_239() {
    if (jj_3R_84()) return true;
    return false;
  }

  final private boolean jj_3R_236() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_230() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_236()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_237()) return true;
    xsp = jj_scanpos;
    if (jj_3R_238()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_239()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_24()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  final private boolean jj_3R_252() {
    if (jj_3R_258()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_259()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_258() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(30)) jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    if (jj_3R_255()) return true;
    return false;
  }

  final private boolean jj_3R_237() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_252()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_241() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_237()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_254()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_243() {
    if (jj_3R_118()) return true;
    return false;
  }

  final private boolean jj_3R_240() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_3R_83()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_21()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_231() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_240()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_91()) return true;
    if (jj_3R_241()) return true;
    xsp = jj_scanpos;
    if (jj_3R_242()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) return true;
    }
    return false;
  }

  final private boolean jj_3R_256() {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  final private boolean jj_3R_246() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_245()) return true;
    return false;
  }

  final private boolean jj_3R_261() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_155() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(139)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_121() {
    if (jj_3R_155()) return true;
    return false;
  }

  final private boolean jj_3R_83() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3_20()) return true;
    }
    return false;
  }

  final private boolean jj_3R_255() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_261()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_180() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_120()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_182() {
    if (jj_3R_189()) return true;
    return false;
  }

  final private boolean jj_3R_245() {
    if (jj_3R_255()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_256()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_250() {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_253()) return true;
    return false;
  }

  final private boolean jj_3R_169() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_120()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_181() {
    if (jj_3R_78()) return true;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_3R_79()) return true;
    return false;
  }

  final private boolean jj_3R_244() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_81() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_170() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_181()) {
    jj_scanpos = xsp;
    if (jj_3R_182()) return true;
    }
    return false;
  }

  final private boolean jj_3R_232() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_244()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_70()) return true;
    if (jj_3R_245()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_246()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3_18() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_81()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  final private boolean jj_3R_80() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_17() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_80()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  final private boolean jj_3R_265() {
    if (jj_3R_232()) return true;
    return false;
  }

  final private boolean jj_3R_264() {
    if (jj_3R_231()) return true;
    return false;
  }

  final private boolean jj_3R_194() {
    if (jj_3R_191()) return true;
    return false;
  }

  final private boolean jj_3R_263() {
    if (jj_3R_229()) return true;
    return false;
  }

  final private boolean jj_3R_251() {
    if (jj_3R_257()) return true;
    return false;
  }

  final private boolean jj_3R_257() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_262()) {
    jj_scanpos = xsp;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_262() {
    if (jj_3R_228()) return true;
    return false;
  }

  final private boolean jj_3R_189() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(125)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_158() {
    if (jj_scan_token(INTERFACE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_250()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_251()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_235() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_229() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_235()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_158()) return true;
    return false;
  }

  final private boolean jj_3R_139() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) return true;
    }
    }
    }
    }
    }
    }
    if (jj_3R_170()) return true;
    return false;
  }

  final private boolean jj_3R_119() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_249() {
    if (jj_scan_token(IMPLEMENTS)) return true;
    if (jj_3R_253()) return true;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_3R_79()) return true;
    return false;
  }

  final private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_79() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_119()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_91()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_77()) jj_scanpos = xsp;
    if (jj_3R_78()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_14() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_76()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_223() {
    if (jj_3R_232()) return true;
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_3R_138()) return true;
    return false;
  }

  final private boolean jj_3_13() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_75()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  final private boolean jj_3R_98() {
    if (jj_3R_139()) return true;
    return false;
  }

  final private boolean jj_3R_222() {
    if (jj_3R_231()) return true;
    return false;
  }

  final private boolean jj_3R_221() {
    if (jj_3R_230()) return true;
    return false;
  }

  final private boolean jj_3R_220() {
    if (jj_3R_229()) return true;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_3R_78()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_scan_token(BANG)) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_219() {
    if (jj_3R_228()) return true;
    return false;
  }

  final private boolean jj_3R_248() {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_78()) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_95()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_96()) jj_scanpos = xsp;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_97()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_98()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_74()) return true;
    return false;
  }

  final private boolean jj_3R_216() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3R_219()) {
    jj_scanpos = xsp;
    if (jj_3R_220()) {
    jj_scanpos = xsp;
    if (jj_3R_221()) {
    jj_scanpos = xsp;
    if (jj_3R_222()) {
    jj_scanpos = xsp;
    if (jj_3R_223()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_234() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_167() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) return true;
    }
    return false;
  }

  final private boolean jj_3R_179() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_168() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_213() {
    if (jj_3R_216()) return true;
    return false;
  }

  final private boolean jj_3R_228() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_234()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_157()) return true;
    return false;
  }

  final private boolean jj_3R_137() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) return true;
    }
    return false;
  }

  final private boolean jj_3R_210() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_213()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_136() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    if (jj_3R_167()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_167()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_94() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) return true;
    }
    return false;
  }

  final private boolean jj_3R_157() {
    if (jj_scan_token(CLASS)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_248()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_249()) jj_scanpos = xsp;
    if (jj_3R_210()) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_67()) return true;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_94()) return true;
    return false;
  }

  final private boolean jj_3R_273() {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_82()) return true;
    return false;
  }

  public AblParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[159];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
      jj_la1_4();
      jj_la1_5();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x4128000,0x0,0x0,0x0,0x0,0x4128000,0x0,0x0,0x0,0x4128000,0x0,0x0,0x4128000,0x0,0x4128000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x4128000,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x20000000,0x0,0x0,0x4128000,0x10000000,0x4128000,0x0,0x0,0x10000000,0x0,0x4432a000,0x40002000,0x40002000,0x44128000,0x40002000,0x40002000,0x40002000,0x40002000,0x10000000,0x4432a000,0x44128000,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x40002000,0x40002000,0x0,0x0,0x0,0x0,0x44128000,0x40000000,0x0,0x0,0x0,0x24128000,0x0,0x4128000,0x0,0x4128000,0x4128000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x24128000,0x0,0x0,0x0,0x20000000,0x0,0x0,0x20000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x2693c000,0x200000,0x40000000,0x0,0x0,0x0,0x24128000,0x1040000,0x1040000,0x8000000,0x64128000,0x24128000,0x24128000,0x0,0x0,0x0,0x80000,0x80000000,0x0,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x2000,0x20,0x20,0x0,0x0,0x0,0x40281,0x0,0x0,0x0,0x0,0x40281,0x0,0x0,0x0,0x40281,0x0,0x0,0x40281,0x0,0x40281,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8001000,0x8001000,0x8001000,0x0,0x0,0x0,0x0,0x0,0x0,0x40281,0x0,0x0,0x0,0x0,0x0,0x0,0x8001000,0x0,0x0,0x0,0x8001000,0x0,0x0,0x40281,0x0,0x40281,0x0,0x0,0x0,0x10,0x644dc781,0x9c000,0x9c000,0x440dc281,0x49c400,0x49c400,0x9c000,0x9c000,0x0,0x644dc781,0x440dc281,0x4409c000,0x4409c000,0x0,0x0,0x0,0x0,0x0,0x49c400,0x49c400,0x2000000,0x0,0x0,0x0,0x40281,0x0,0x1c000,0x1c000,0x2000000,0x28941a81,0x80000,0x40281,0x0,0x40281,0x20040281,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28941a81,0x0,0x0,0x0,0x8901800,0x0,0x0,0x8001000,0x8000000,0x0,0x0,0x0,0x800,0x0,0x0,0xb9f61a8b,0x100,0x0,0x0,0x0,0x0,0x28941a81,0x0,0x0,0x0,0x28941a81,0x28941a81,0x28941a81,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x200,0x200,0x80000,0x800,0x100,0x0,0x2040084,0x20000,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x40004,0x0,0x0,0x20802400,0x0,0x20440c1,0x20802400,0x0,0x20440c1,0x2000080,0x40004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20440c1,0x20400c1,0x0,0x0,0x20440c1,0xdd009000,0xc0000000,0x4000000,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x8003,0x100004,0x0,0x0,0x0,0x0,0x8003,0x0,0x0,0x0,0x100000,0x0,0x0,0xe00210,0x0,0xe486c,0xe00210,0x0,0xe486c,0x4,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0xb1000000,0xb1000000,0xb1000000,0x0,0x0,0x4000,0xe486c,0xe082c,0xe0000,0x0,0xe486c,0x581,0x0,0x0,0x3000,0x0,0xb1000000,0x0,0x28,0x0,0xb1000000,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb1000000,0x0,0x0,0x0,0xb1000000,0x0,0x0,0xb1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb1000000,0x0,0x0,0x0,0x0,0x0,0xb1000000,0x0,0x0,0x0,0xb1000000,0xb1000000,0xb1000000,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x1000,0x2,0x2,0x0,0x2,0x800,0x2,0x0,0x800,0x2,0x0,0x2,0x0,0x0,0x2,0x0,0x0,0x0,0x10052,0x10,0x10012,0x10,0x10052,0x10000,0x2,0x2,0xf0c000,0x1,0x3,0x3,0x800,0x800,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x800,0x3,0x0,0x0,0x800,0x3,0x0,0x800,0x2,0x0,0x2,0x0,0x1000,0x0,0x0,0x42,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x800,0x2000,0x100,0x40,0x800,0x0,0x0,0x0,0x440,0x100,0x800,0x2,0x0,0x0,0x0,0x0,0x13,0x0,0x2,0x100,0x0,0x2,0x800,0x2000,0x2000,0x40000,0x1000000,0x2000000,0x0,0x0,0x0,0x900000,0x900000,0x0,0x60c000,0x60c000,0x0,0x0,0x30000000,0x30000000,0xc0000000,0xc0000000,0x30000000,0x3c000000,0x30000,0x30000,0x13,0xc000000,0xc000000,0x10,0x11,0x2,0x1110,0x1,0x0,0x800,0x40,0x110,0x0,0x100,0x100,0xc000453,0x0,0x0,0x800,0xc002000,0xc002000,0xc000013,0x0,0x0,0x0,0xc000013,0xc000013,0xc000013,0x800,0x2,0x2,0x0,0x0,0x80000,};
   }
   private static void jj_la1_5() {
      jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ff80,0x3ff80,0x0,0x0,0x0,0x2,0x4,0x1,0x0,0x0,0x0,0x0,0x0,0x70,0x70,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ff80,0x3ff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[45];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public AblParser(java.io.InputStream stream) {
     this(stream, null);
  }
  public AblParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new AblParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 159; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 159; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public AblParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new AblParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 159; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 159; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public AblParser(AblParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 159; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(AblParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 159; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[178];
    for (int i = 0; i < 178; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 159; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 178; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 45; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
