/* Represents an argument of a primitive act, subgoal or behavior. */

// TODO: Change AblArgument so that it uses types of the form "java.lang.*" as the string representation of the type.
// This will simplify the main user of this class, ArgumentStep. Will need to decide what getType() should return 
// for the purposes of defining signatures. 

package abl.compiler;

public class AblArgument {
    private Object argument; /* The java object representing the argument value. */
    private String type; // The argument type.

    // True if the argument is a string representing a variable reference; false otherwise. 
    private boolean variableReference; 
    
    public AblArgument(Object argumentToSet, String typeToSet) {
	argument = argumentToSet;
	type = typeToSet;
	variableReference = false; 
    }

    public AblArgument(Object argumentToSet, String typeToSet, boolean varRef) {
	if (varRef) // If the argument is a variable reference, must be a string
	    if (!argumentToSet.getClass().getName().equals("java.lang.String")) 
		throw new CompileError("Attempt to set a non-String argument in a variable reference AblArgument");
	variableReference = varRef;
	type = typeToSet.intern();
	argument = argumentToSet;
    }

    public String getType() {
	return type;
    }

    /* toString() produces a string representation of the java object
       represented by the AblArgument. For example, if the argument
       was an Integer (with int value 3), the String representation
       would be "new Integer(3)". If the argument was a String with
       value "parent.var", and variableReference was true, then the
       String representation would be "parent.var" (as opposed to new
       String("parent.var"). */
    public String toString() {
	StringBuffer buf = new StringBuffer();
	
	if (AblParseNode.primitiveType(type)) {
	    if (type.equals("int"))
		buf.append("new Integer(");
	    else if (type.equals("float"))
		buf.append("new Float(");
	    else if (type.equals("double"))
		buf.append("new Double(");
	    else if (type.equals("char"))
		buf.append("new Character(");
	    else if (type.equals("boolean"))
		buf.append("new Boolean(");
	    else if (type.equals("null"))
		return "null";
	    else if (type.equals("long"))
		buf.append("new Long(");
	    else if (type.equals("short"))
		buf.append("new Short(");
	    else if (type.equals("byte"))
		buf.append("new Byte(");
	    else 
		throw new CompileError("Unrecognized primitive type " + type + " in a AblArgument.");
	    
	    buf.append(argument + ")");
	}
	else if (type.equals("String")) {
	    buf.append("new String(" + argument + ")");
	}	    
	else {
	    // Not a primitive type or string, directly output the variable reference

	    if (!variableReference)
		throw new CompileError("Literal non-primitive reference to type " + type + " in a AblArgument.");
	    
	    buf.append(argument);
	}
	
	return buf.toString();
    }
}

