package abl.compiler;

import jd.*;
import abl.runtime.Step;

public class ASTWaitStep extends GenericStep implements AblDebuggerConstants {
    ASTWaitStep(int id) {
        super(id);
    }
    
    ASTWaitStep(AblParser p, int id) {
        super(p, id);
    }
    
    private CodeBlockDescriptor compileStepFactory() throws CompileException
    {
        CodeBlockDescriptor stepFactory = new CodeBlockDescriptor("case " + stepID + ": {", "}");
        
        stepFactory.addToBlockBody(new CodeStringDescriptor("// " + getUniqueName()));
        
        final CodeSequenceDescriptor propertyTableInit = compilePropertyTable();
        if (propertyTableInit != null)
            stepFactory.addToBlockBody(propertyTableInit);
        
        if (Abl.debugLevel == GUI_DEBUGGER)
            // construct debug versions of steps
            stepFactory.addToBlockBody(new CodeStringDescriptor("return new WaitStepDebug(" + 
            standardConstructorArguments() + ");"));
        else
            stepFactory.addToBlockBody(new CodeStringDescriptor("return new WaitStep(" + 
            standardConstructorArguments() + ");"));
        
        return stepFactory;
    }
    
    void compileToJava() throws CompileException 
    {
        final ASTBehaviorUnit behaviorUnitNode = ASTBehaviorUnit.getBehaviorUnit();
        final ASTBehaviorDefinition behaviorParent = (ASTBehaviorDefinition)jjtGetParent();
        
        if (hasModifiers()) {
            // compile specific factories for wait steps with modifiers (typically success tests and/or user properties)
            initStep(Step.WAIT);
            
            if (hasSuccessTest)
                compileSuccessTest();
            
            // Compile the step factory at the end since the factory references the class and method names of the 
            // other step parts (e.g. success test, sensor factories, execute).
            behaviorUnitNode.writeStepFactory(compileStepFactory(), this);
            
        }
        else {
            // wait steps without modifiers share the default wait step
            initStep(ASTBehaviorUnit.DEFAULT_WAIT_STEP);
        }
        
        // Add the step id and factory method to the parent's list of steps.
        behaviorParent.addStep(stepID, getStepFactoryMethod_rField());
    }

}
