/* Parse node for WME registrations. */

package abl.compiler;

public class ASTWMERegistration extends AblParseNode {

    /* Name of the registered WME. */
    public String registeredWME;
    
    public ASTWMERegistration(int id) {
	super(id);
    }
    
    public ASTWMERegistration(AblParser p, int id) {
	super(p, id);
    }
    
    public String getRegisteredWME() {
	return registeredWME;
    }

    /* Returns the sensor the WME is registered on. Gets the sensor
       name by calling dumpTokens on ASTJavaName. */
    public String getSensorWMERegisteredOn() {
	return ((AblParseNode)jjtGetChild(0)).dumpTokens();
    }
    
}
