/* Parse node for the a WME field test. */

package abl.compiler;

import jd.*;

public class ASTWMEFieldTest extends AblParseNode {

    String wmeFieldName; // Name of the wme field to test. 
    int testOp; // The test operator. 
    ASTAblExpression wmeTestOperand; // The operand the field is being compared against. 

    // Need to deal with the fact that the operand can be either a variable or a constant expression. If it is a variable,
    // it may appear in the behavior scope, global scope or not appear in either scope. In the event that it doesn't
    // appear in either scope, it should be defined within the enclosing behavior scope (at least for preconditions 
    // and context conditions). For success tests, the variable appears in a success test scope (success tests become
    // scope maintainers) that isn't visible to anyone else. For success tests, the implementation variable should be 
    // defined as a local within the success test function. 

    ASTWMEFieldTest(int id) {
        super(id);
    }

    ASTWMEFieldTest(AblParser p, int id) {
        super(p, id);
    }

    // fixme: modify this to efficiently check isProperty() (don't depend on catching exceptions)
    // returns true if wmeFieldName references a property rather than a WME field    
    /* boolean isProperty()
    {
    String wmeFieldTypeName;
    String wmeClassName = ((ASTWMETest)jjtGetParent()).wmeClassName;
    ASTBehaviorUnit behUnit = ASTBehaviorUnit.getBehaviorUnit();
    
    if (WorkingMemory.isReflectionWME(wmeClassName)) {
        // Only tests on reflection wmes have a chance of referencing properties
        try {
    	getWMEFieldType(wmeClassName, wmeFieldName).getName();
    	return false; // if we got this far (getWMEFieldType didn't throw an exception) then this is a WME field
        } catch(NoSuchMethodException e) { 
    	// Field doesn't exist. See if the field references a named property.
    	String propertyType = ASTBehaviorUnit.getBehaviorUnit().lookupDeclaredProperty(wmeFieldName);
    	if (propertyType != null) {
    	    return true;  // found a declared property
    	}
    	else
    	    throw new NoSuchFieldException(); 
        }
        
    }
    else
        return false; 
        }*/

    // fixme: get rid of this when compile-time checks are more efficient
    // returns true if wmeFieldName references a property rather than a WME field
    boolean isProperty() throws ClassNotFoundException, NoSuchFieldException {
        String wmeFieldTypeName;
        String wmeClassName = ((ASTWMETest) jjtGetParent()).wmeClassName;
        ASTBehaviorUnit behUnit = ASTBehaviorUnit.getBehaviorUnit();

        // First try the locally defined WMEs. 
        if (behUnit.isWMEDeclared(wmeClassName)) {
            // If the wme class has been declared in the behavior unit, look up the field type

            wmeFieldTypeName = behUnit.lookupWMEFieldType(wmeClassName, wmeFieldName);
            if (wmeFieldTypeName != null)
                return false; // not a property
            else {
                // The wme class was declared in the behavior unit, but the field doesn't exist. 

                // See if the field references a named property.
                String propertyType = ASTBehaviorUnit.getBehaviorUnit().lookupDeclaredProperty(wmeFieldName);
                if (propertyType != null) {
                    // found a declared property
                    return true;
                } else
                    throw new NoSuchFieldException();
            }
        } else {
            // The wme class was not declared in the behaving entity. Look for a precompiled wme class. 
            try {
                getWMEFieldType(wmeClassName, wmeFieldName).getName();
                return false; // if we got this far (getWMEFieldType didn't throw an exception) then this is a WME field
            } catch (NoSuchMethodException e) {
                // Field doesn't exist. See if the field references a named property.
                String propertyType = ASTBehaviorUnit.getBehaviorUnit().lookupDeclaredProperty(wmeFieldName);
                if (propertyType != null) {
                    return true; // found a declared property
                } else
                    throw new NoSuchFieldException();
            }
        }
    }

    private String getWMEFieldType() throws ClassNotFoundException, NoSuchFieldException {

        String wmeFieldTypeName;
        String wmeClassName = ((ASTWMETest) jjtGetParent()).wmeClassName;
        ASTBehaviorUnit behUnit = ASTBehaviorUnit.getBehaviorUnit();

        // First try the locally defined WMEs. 
        if (behUnit.isWMEDeclared(wmeClassName)) {
            // If the wme class has been declared in the behavior unit, look up the field type

            wmeFieldTypeName = behUnit.lookupWMEFieldType(wmeClassName, wmeFieldName);
            if (wmeFieldTypeName != null)
                return wmeFieldTypeName;
            else {
                // The wme class was declared in the behavior unit, but the field doesn't exist. 

                // See if the field references a named property.
                String propertyType = ASTBehaviorUnit.getBehaviorUnit().lookupDeclaredProperty(wmeFieldName);
                if (propertyType != null) {
                    // found a declared property
                    return "Object"; // all properties are Objects (primitives are wrapped)
                } else
                    throw new NoSuchFieldException();
            }
        } else {
            // The wme class was not declared in the behaving entity. Look for a precompiled wme class. 
            try {
                return getWMEFieldType(wmeClassName, wmeFieldName).getName();
            } catch (NoSuchMethodException e) {
                // Field doesn't exist. See if the field references a named property.
                String propertyType = ASTBehaviorUnit.getBehaviorUnit().lookupDeclaredProperty(wmeFieldName);
                if (propertyType != null) {
                    // found a declared property
                    return "Object"; // all properties are Objects (primitives are wrapped)
                } else
                    throw new NoSuchFieldException();
            }
        }
    }

    /* If the wmeTestOperand is a variable and the operator is bind,
    checks whether it is defined in the behavior or global scope. If
    the variable is defined in one of these scopes, returns null. If
    the variable isn't defined, returns a FieldDescriptor describing
    the variable's name and type. Presumably the caller will use this
    information to define the variable in the appropriate scope
    (behavior scope for context conditions and preconditions, local
    scope for success tests). The reason only bind operations are
    considered is bind is the only way to legally introduce a new
    variable in the scope. If a new variable is referenced in a test
    (non-bind), then that variable must have been defined somewhere
    and further must have a value. */
    public FieldDescriptor preprocessVariableRef() throws CompileException {
        try {
            // fixme: this will force references to undefined wmes or wme fields to be reported
            // do something more elegant for error checking bind and non-bind operator cases
            String wmeFieldType = getWMEFieldType();
            if (wmeTestOperand.isIdentifier() && testOp == V_BIND) {
                AblScopeMaintainer scope = ((ASTWMETest) jjtGetParent()).getEnclosingBehaviorScope();
                if (!wmeTestOperand.getRef().isVariableReference(scope)) {
                    // Not a variable reference - return a new variable declaration.

                    FieldDescriptor newVar = new FieldDescriptor();
                    newVar.addFieldName(wmeTestOperand.getRef().getName());
                    newVar.fieldType = wmeFieldType;
                    return newVar;
                } else {
                    // Reference to an already existing declared variable - check type.
                    String argType = wmeTestOperand.getRef().lookupFieldType(scope);
                    if ((primitiveType(argType) && !argType.equals(wmeFieldType)) || (!primitiveType(argType) && !getClass(argType).isAssignableFrom(getClass(wmeFieldType))))
                        // fixme: change CompileException to take the parse node as an argument instead of 
                        // manually calling getFirstLineNumber()
                        throw new CompileException(getFirstLineNumber(), "Type error in WME field test: " + dumpTokens() + ". Attempt to assign WME field of type " + wmeFieldType + " to variable of type " + argType);
                }
            }
            return null;
        } catch (ClassNotFoundException e) {
            // fixme: change CompileException to take the parse node as an argument
            throw new CompileException(getFirstLineNumber(), "Reference to undefined WME " + e.getMessage() + " in WME test: " + dumpTokens());
        } catch (NoSuchFieldException e) {
            // fixme: change CompileException to take the parse node as an argument
            throw new CompileException(getFirstLineNumber(), "Reference to undefined WME field in WME test: " + dumpTokens());
        }
    }

	// If the field test references an explicitly declared variable, return a FieldDescriptor for that variable, otherwise return null. 
	final FieldDescriptor getExplicitlyDeclaredVariableReference() {
		final AblScopeMaintainer scope = ((ASTWMETest) jjtGetParent()).getEnclosingBehaviorScope();
		final ASTJavaName ref = wmeTestOperand.getRef();
		// fixme: should I also check global scope as well? Do some experiments...
		if ((ref != null) && (scope.lookupVariableScope(ref.getName()) == AblScopeMaintainer.BEHAVIOR_SCOPE)) {
			return scope.lookupVariable(ref.getName());		 
		}
		else {
			return null; 
		}
	}

    /* If the test binds a variable, return the name of the variable,
       else return null. */
    public String getBoundVariable() {
        if (wmeTestOperand.isIdentifier() && (testOp == V_BIND)) {
            return wmeTestOperand.getRef().getName();
        } else
            return null;
    }

    public int getTestType() {
        return ((ASTWMETest) jjtGetParent()).getTestType();
    }

    public JavaCodeDescriptor compileToJava() throws CompileException {
        int wmeCount = ((ASTWMETest) jjtGetParent()).getWMECounter();
        String ref = ((ASTWMETest) jjtGetParent()).resolveOperandInFieldTest(this);

        StringBuffer codeString = new StringBuffer();

        // Create the get accessor name. If the field references a property rather than an actual WME field, 
        // then the get accessor becomes "getProperty(<propertyName>)".
        String getAccessorName;
        try {
            if (isProperty())
                getAccessorName = "getProperty(\"" + wmeFieldName + "\")";
            else
                getAccessorName = "get" + uppercaseFirstCharacter(wmeFieldName) + "()";
        } catch (ClassNotFoundException e) {
            throw new CompileException(getFirstLineNumber() + "BReference to undefined WME " + e.getMessage() + " in WME test: " + dumpTokens());
        } catch (NoSuchFieldException e) {
            throw new CompileException(getFirstLineNumber() + "Reference to undefined WME field in WME test: " + dumpTokens());
        }

        if ((testOp) == V_BIND) {
            //Variable bind operator; the order of the field
            //references and variable reference are reversed.

            codeString.append("BehavingEntity.constantTrue(" + ref + " = " + "wme__" + wmeCount + "." + getAccessorName + ")");
        } else {
            // Not a variable bind operator. 
            // fixme: Eventually should add code to type check the operand and the wme field. 

            String fieldType;
            try {
                fieldType = getWMEFieldType();
            } catch (ClassNotFoundException e) {
                // fixme: change CompileException to take the parse node as an argument
                throw new CompileException(getFirstLineNumber() + "CReference to undefined WME " + e.getMessage() + " in WME test: " + dumpTokens());
            } catch (NoSuchFieldException e) {
                // fixme: change CompileException to take the parse node as an argument
                throw new CompileException(getFirstLineNumber() + "Reference to undefined WME field in WME test: " + dumpTokens());
            }

            // fixme: settle on a single string representation for the String type
            if ((fieldType.equals("java.lang.String") || fieldType.equals("String")) && stripQuotes(tokenImage[testOp]).equals("==")) {
                // The field test is an equality test of Strings. Use equals() to deal with problem of lack of reference equality for non-interned strings
                codeString.append("(wme__" + wmeCount + "." + getAccessorName + ".equals(" + ref + "))");
            } 
            else if ((fieldType.equals("java.lang.String") || fieldType.equals("String")) && stripQuotes(tokenImage[testOp]).equals("!=")) {
                // The field test is a non-equality test of Strings. Use ! equals() to deal with problem of lack of reference equality for non-interned strings
                codeString.append("(!wme__" + wmeCount + "." + getAccessorName + ".equals(" + ref + "))");
            } else {

                codeString.append("( wme__" + wmeCount + "." + getAccessorName + " " + stripQuotes(tokenImage[testOp]) + " ");

                // String operands contains the \" characters in the
                // token image, so don't need to do anything special.
                codeString.append(ref + " )");
            }
        }
        return new CodeStringDescriptor(codeString.toString());
    }
}
